/*
 * Decompiled with CFR 0.152.
 */
package com.commit451.foregroundviews;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.commit451.foregroundviews.ForegroundDelegate;

public class ForegroundLinearLayout
extends LinearLayout {
    ForegroundDelegate mForegroundDelegate;

    public ForegroundLinearLayout(Context context) {
        this(context, null);
    }

    public ForegroundLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ForegroundLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle, 0);
    }

    @TargetApi(value=21)
    public ForegroundLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate = new ForegroundDelegate((View)this);
            this.mForegroundDelegate.init(context, attrs, defStyleAttr, defStyleRes);
        }
    }

    public int getForegroundGravity() {
        if (Build.VERSION.SDK_INT >= 23) {
            return super.getForegroundGravity();
        }
        return this.mForegroundDelegate.getForegroundGravity();
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (Build.VERSION.SDK_INT >= 23) {
            super.setForegroundGravity(foregroundGravity);
        } else {
            this.mForegroundDelegate.setForegroundGravity(foregroundGravity);
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        if (Build.VERSION.SDK_INT < 23) {
            return super.verifyDrawable(who) || who == this.mForegroundDelegate.getForeground();
        }
        return super.verifyDrawable(who);
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.jumpDrawablesToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.drawableStateChanged();
        }
    }

    public void setForeground(Drawable foreground) {
        if (Build.VERSION.SDK_INT >= 23) {
            super.setForeground(foreground);
        } else {
            this.mForegroundDelegate.setForeground(foreground);
        }
    }

    public Drawable getForeground() {
        if (Build.VERSION.SDK_INT >= 23) {
            return super.getForeground();
        }
        return this.mForegroundDelegate.getForeground();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.onLayout(changed, left, top, right, bottom);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.draw(canvas);
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (Build.VERSION.SDK_INT < 23) {
            this.mForegroundDelegate.drawableHotspotChanged(x, y);
        }
    }
}

