/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier.closure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncompleteSupertypesException;
import org.clyze.jphantom.hier.closure.AbstractSnapshot;
import org.objectweb.asm.Type;

public class PseudoSnapshot
extends AbstractSnapshot {
    public PseudoSnapshot(ClassHierarchy hierarchy) {
        super(hierarchy);
    }

    @Override
    public List<Type> getAllSuperclasses(Type obj) throws IncompleteSupertypesException {
        this.checkedContainedObject(obj);
        ArrayList<Type> superclasses = new ArrayList<Type>();
        while ((obj = this.getSuperclass(obj)) != null) {
            superclasses.add(obj);
            if (this.contains(obj)) continue;
            throw new IncompleteSupertypesException(superclasses);
        }
        return superclasses;
    }

    @Override
    public Set<Type> getAllInterfaces(Type obj) throws IncompleteSupertypesException {
        List<Type> superclasses;
        this.checkedContainedObject(obj);
        try {
            superclasses = this.getAllSuperclasses(obj);
        }
        catch (IncompleteSupertypesException exc) {
            superclasses = exc.getSupertypes();
        }
        try {
            Set<Type> supertypes = this.getAllSupertypes(obj);
            supertypes.removeAll(superclasses);
            return supertypes;
        }
        catch (IncompleteSupertypesException exc) {
            exc.getSupertypes().removeAll(superclasses);
            throw exc;
        }
    }

    @Override
    public Set<Type> getAllSupertypes(Type obj) throws IncompleteSupertypesException {
        this.checkedContainedObject(obj);
        HashSet<Type> supertypes = new HashSet<Type>();
        LinkedList<Type> queue = new LinkedList<Type>();
        boolean incomplete = false;
        do {
            queue.add(obj);
            while (!queue.isEmpty()) {
                Type t = (Type)queue.poll();
                supertypes.add(t);
                if (!this.contains(t)) {
                    incomplete = true;
                    continue;
                }
                queue.addAll(this.getInterfaces(t));
            }
        } while (this.contains(obj) && (obj = this.getSuperclass(obj)) != null);
        if (incomplete) {
            throw new IncompleteSupertypesException(supertypes);
        }
        return supertypes;
    }

    @Override
    public Type firstCommonSuperclass(Type a, Type b) throws IncompleteSupertypesException {
        this.checkedContainedObject(a);
        this.checkedContainedObject(b);
        HashSet<Type> visited = new HashSet<Type>();
        boolean incomplete = false;
        while (a != null || b != null) {
            if (a != null) {
                if (!visited.add(a)) {
                    return a;
                }
                if (!this.contains(a)) {
                    incomplete = true;
                }
                Type type = a = this.contains(a) ? this.getSuperclass(a) : null;
            }
            if (b == null) continue;
            if (!visited.add(b)) {
                return b;
            }
            if (!this.contains(b)) {
                incomplete = true;
            }
            b = this.contains(b) ? this.getSuperclass(b) : null;
        }
        if (incomplete) {
            throw new IncompleteSupertypesException();
        }
        return null;
    }
}

