/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.hier.AbstractClassHierarchy;
import org.objectweb.asm.Type;

public class SystemClassHierarchy
extends AbstractClassHierarchy {
    private static final Map<ClassLoader, SystemClassHierarchy> systemHier = new HashMap<ClassLoader, SystemClassHierarchy>();
    private final ClassLoader loader;

    private SystemClassHierarchy(ClassLoader loader) {
        this.loader = loader;
    }

    public static SystemClassHierarchy getInstance(ClassLoader loader) {
        if (!systemHier.containsKey(loader)) {
            systemHier.put(loader, new SystemClassHierarchy(loader));
        }
        return systemHier.get(loader);
    }

    @Override
    public void addClass(Type clazz, Type superclass, Type[] interfaces) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInterface(Type iface, Type[] superInterfaces) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInterface(Type obj) {
        return this.asClass(obj).isInterface();
    }

    @Override
    public boolean contains(Type obj) {
        try {
            Class.forName(obj.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException exc) {
            return false;
        }
        return true;
    }

    @Override
    public Set<Type> getInterfaces(Type obj) {
        HashSet<Type> ifaces = new HashSet<Type>();
        for (Class<?> c : this.asClass(obj).getInterfaces()) {
            ifaces.add(SystemClassHierarchy.asType(c));
        }
        return ifaces;
    }

    @Override
    public Type getSuperclass(Type obj) {
        Class<Object> superclass = this.isInterface(obj) ? Object.class : this.asClass(obj).getSuperclass();
        return SystemClassHierarchy.asType(superclass);
    }

    private Class<?> asClass(Type obj) {
        try {
            return Class.forName(obj.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Iterator<Type> iterator() {
        throw new UnsupportedOperationException();
    }

    public static final Type asType(Class<?> clazz) {
        return Type.getType(clazz);
    }
}

