/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.constraints.solvers.AbstractSolver;
import org.clyze.jphantom.constraints.solvers.Colored;
import org.clyze.jphantom.constraints.solvers.InterfaceSolver;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;

public class MinClassesStrategy<V, E>
implements InterfaceSolver.Strategy<V, E> {
    private final Map<V, Colored<V>> colored = new HashMap<V, Colored<V>>();
    private final V root;
    private DirectedGraph<V, E> graph;

    MinClassesStrategy(V root) {
        this.root = root;
    }

    protected Colored<V> getColored(V vertex) {
        if (!this.colored.containsKey(vertex)) {
            this.colored.put((Colored<V>)vertex, (Colored<Colored<V>>)new Colored<V>(vertex));
        }
        return this.colored.get(vertex);
    }

    @Override
    public void markClass(V vertex) {
        this.getColored(vertex).setType(Colored.Type.CLASS);
    }

    @Override
    public void markInterface(V vertex) {
        this.getColored(vertex).setType(Colored.Type.INTERFACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> classSubsetOf(DirectedGraph<V, E> graph) throws AbstractSolver.GraphCycleException {
        HashMap<V, Colored<V>> backup = new HashMap<V, Colored<V>>(this.colored);
        try {
            this.graph = graph;
            for (V v : this.colored.keySet()) {
                if (graph.containsVertex(v)) continue;
                throw new IllegalArgumentException();
            }
            this.determineTypes();
            HashSet<V> classes = new HashSet<V>();
            for (Colored<Object> v : this.colored.values()) {
                if (v.getType() != Colored.Type.CLASS) continue;
                classes.add(v.get());
            }
            for (Colored<Object> v : graph.vertexSet()) {
                assert (this.getColored(v).resolved());
            }
            HashSet<V> hashSet = classes;
            return hashSet;
        }
        finally {
            this.colored.clear();
            this.colored.putAll(backup);
        }
    }

    private void mark(V vertex, Colored.Type type) throws AbstractSolver.GraphCycleException {
        List touched;
        this.getColored(vertex).setType(type);
        this.getColored(vertex).color = Colored.Color.GREY;
        List list = touched = type == Colored.Type.INTERFACE ? Graphs.successorListOf(this.graph, vertex) : Graphs.predecessorListOf(this.graph, vertex);
        if (type == Colored.Type.INTERFACE) {
            touched.remove(this.root);
        }
        if (vertex.equals(this.root)) {
            touched = Collections.emptyList();
        }
        for (Object next : touched) {
            switch (this.getColored(next).color) {
                case WHITE: {
                    this.mark(next, type);
                    break;
                }
                case GREY: {
                    throw new AbstractSolver.GraphCycleException();
                }
                case BLACK: {
                    this.getColored(next).setType(type);
                }
            }
        }
        this.getColored(vertex).color = Colored.Color.BLACK;
    }

    private void determineTypes() throws AbstractSolver.GraphCycleException {
        HashSet rootSet = new HashSet();
        for (Object v : this.graph.vertexSet()) {
            if (this.getColored(v).resolved()) {
                rootSet.add(v);
            }
            this.getColored(v).color = Colored.Color.WHITE;
        }
        for (Object v : rootSet) {
            if (this.getColored(v).color != Colored.Color.WHITE) continue;
            this.mark(v, this.getColored(v).getType());
        }
        for (Object v : this.graph.vertexSet()) {
            if (this.getColored(v).resolved()) continue;
            this.getColored(v).setType(Colored.Type.INTERFACE);
        }
    }
}

