/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.adapters;

import java.io.IOException;
import java.util.HashSet;
import org.clyze.jphantom.ClassMembers;
import org.clyze.jphantom.Phantoms;
import org.clyze.jphantom.hier.ClassHierarchies;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomAdder
extends SignatureVisitor
implements Opcodes {
    private final ClassHierarchy hierarchy;
    private final ClassMembers members;
    private final Phantoms phantoms;
    private static final Logger logger = LoggerFactory.getLogger(PhantomAdder.class);

    public PhantomAdder(ClassHierarchy hierarchy, ClassMembers members, Phantoms phantoms) {
        super(589824);
        this.hierarchy = hierarchy;
        this.members = members;
        this.phantoms = phantoms;
    }

    public void visitInnerClassType(String name) {
        this.visitClassType(name);
    }

    public void visitClassType(String name) {
        this.visitClassType(Type.getObjectType((String)name));
    }

    public void visitClassType(Type objType) {
        assert (objType.getSort() == 10);
        if (this.hierarchy.contains(objType)) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(objType.getClassName(), false, null);
            HashSet<Type> prev = new HashSet<Type>();
            for (Type t : this.hierarchy) {
                prev.add(t);
            }
            ClassHierarchies.loadSystemType(this.hierarchy, clazz);
            assert (this.hierarchy.contains(objType) && !prev.contains(objType));
            for (Type t : this.hierarchy) {
                if (prev.contains(t)) continue;
                new ClassReader(t.getInternalName()).accept((ClassVisitor)new ClassMembers.Feeder(this.members), 0);
            }
            return;
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (IOException exc) {
            logger.warn("Could not locate library type: {}", (Object)objType);
            throw new RuntimeException(exc);
        }
        if (!this.phantoms.contains(objType)) {
            this.phantoms.getTransformer(objType);
            logger.info("Phantom Class \"{}\" detected", (Object)objType.getClassName());
        }
    }
}

