/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.access;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import org.clyze.jphantom.access.AccessStateMachine;
import org.clyze.jphantom.access.Event;
import org.clyze.jphantom.access.FieldAccessEvent;
import org.clyze.jphantom.access.State;
import org.clyze.jphantom.constraints.IsaClassConstraint;
import org.objectweb.asm.Type;

public class FieldAccessStateMachine
extends AccessStateMachine {
    public static final State EMPTY_STATE = new State().asPublic();
    public static final State FINAL_STATE = new State(16).asPublic();
    public static final State STATIC_STATE = new State(8).asPublic();
    public static final State STATIC_FINAL_STATE = new State(24).asPublic();
    private final Table<State, Event, State> transitions = new ImmutableTable.Builder().put((Object)FINAL_STATE, (Object)new Event(180), (Object)FINAL_STATE).put((Object)FINAL_STATE, (Object)new Event(181), (Object)EMPTY_STATE).put((Object)FINAL_STATE, (Object)new Event(178), (Object)STATIC_FINAL_STATE).put((Object)FINAL_STATE, (Object)new Event(179), (Object)STATIC_STATE).put((Object)EMPTY_STATE, (Object)new Event(181), (Object)EMPTY_STATE).put((Object)EMPTY_STATE, (Object)new Event(180), (Object)EMPTY_STATE).put((Object)STATIC_STATE, (Object)new Event(178), (Object)STATIC_STATE).put((Object)STATIC_STATE, (Object)new Event(179), (Object)STATIC_STATE).put((Object)STATIC_FINAL_STATE, (Object)new Event(178), (Object)STATIC_FINAL_STATE).put((Object)STATIC_FINAL_STATE, (Object)new Event(179), (Object)STATIC_STATE).build();
    public static FieldAccessStateMachine instance = new FieldAccessStateMachine();
    private Map<String, EventSequence> sequences = new HashMap<String, EventSequence>();

    protected Table<State, Event, State> delegate() {
        return this.transitions;
    }

    protected FieldAccessStateMachine() {
        super(FINAL_STATE);
    }

    public static FieldAccessStateMachine v() {
        return instance;
    }

    public static void refresh() {
        instance = new FieldAccessStateMachine();
    }

    public EventSequence getEventSequence(String fieldName, Type owner) {
        String key = owner.getClassName() + ":" + fieldName;
        if (!this.sequences.containsKey(key)) {
            this.sequences.put(key, new EventSequence(fieldName, owner));
        }
        return this.sequences.get(key);
    }

    public class EventSequence
    extends AccessStateMachine.EventSequence {
        private final String fieldName;
        private final Type owner;
        private String desc;

        private EventSequence(String name, Type owner) {
            super(FieldAccessStateMachine.this);
            this.fieldName = name;
            this.owner = owner;
        }

        protected EventSequence checkDescriptor(String descriptor) {
            if (this.desc == null) {
                this.desc = descriptor;
            } else if (!this.desc.equals(descriptor)) {
                throw new IllegalStateException("Field '" + this.owner.getClassName() + " " + this.fieldName + "' has multiple descriptors: " + this.desc + " " + descriptor);
            }
            return this;
        }

        @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
        public EventSequence moveTo(FieldAccessEvent event) {
            super.moveTo(event);
            switch (event.getOpcode()) {
                case 179: 
                case 180: 
                case 181: {
                    FieldAccessStateMachine.this.addConstraint(new IsaClassConstraint(this.owner));
                }
                case 178: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return this.checkDescriptor(event.desc);
        }
    }
}

