/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.access;

import org.clyze.jphantom.access.Event;

public class FieldAccessEvent
extends Event {
    public final String name;
    public final String desc;

    private FieldAccessEvent(Builder builder) {
        super(builder.opcode);
        this.name = builder.fName;
        this.desc = builder.desc;
    }

    @Override
    public String toString() {
        return "Accessing field: " + this.name + this.desc + " " + super.toString();
    }

    public static class Builder {
        private String fName = null;
        private String desc = null;
        private int opcode = 0;

        public FieldAccessEvent build() {
            return new FieldAccessEvent(this);
        }

        public Builder setName(String name) {
            this.fName = name;
            return this;
        }

        public Builder setDescriptor(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setOpcode(int opcode) {
            switch (opcode) {
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal Field Access Instruction Opcode: " + opcode);
                }
            }
            this.opcode = opcode;
            return this;
        }
    }
}

