/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom;

import org.objectweb.asm.Type;

public class ArrayTypes {
    private ArrayTypes() {
        throw new AssertionError();
    }

    public static Type newType(Type elementType, int dimension) {
        if (dimension < 1) {
            throw new IllegalArgumentException("Non-positive dimension argument: " + dimension);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            builder.append("[");
        }
        builder.append(elementType.getDescriptor());
        return Type.getObjectType((String)("" + builder));
    }

    public static Type newType(Type elementType) {
        return ArrayTypes.newType(elementType, 1);
    }

    public static Type checkedArrayType(Type arrayType) {
        if (arrayType == null || arrayType.getSort() != 9) {
            throw new IllegalArgumentException("Non-array type: " + arrayType);
        }
        Type type = ArrayTypes.newType(arrayType.getElementType(), arrayType.getDimensions());
        assert (arrayType.equals((Object)type));
        return type;
    }

    public static Type elementOf(Type arrayType) {
        int dim = ArrayTypes.checkedArrayType(arrayType).getDimensions();
        Type basic = arrayType.getElementType();
        return dim-- == 1 ? basic : ArrayTypes.newType(basic, dim);
    }
}

