/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.methods;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncrementalClassHierarchy;
import org.clyze.jphantom.hier.graph.GraphConverter;
import org.clyze.jphantom.hier.graph.Node;
import org.clyze.jphantom.methods.MethodLookupTable;
import org.clyze.jphantom.methods.MethodSignature;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultEdge;
import org.objectweb.asm.Type;

public class MethodDeclarations
implements Types {
    private final ClassHierarchy hierarchy;
    private final MethodLookupTable mtable;
    private final Map<Type, Set<MethodSignature>> pending = new HashMap<Type, Set<MethodSignature>>();
    private final Map<Type, Set<MethodSignature>> implemented = new HashMap<Type, Set<MethodSignature>>();

    public MethodDeclarations(ClassHierarchy hierarchy, MethodLookupTable mtable) {
        this.hierarchy = new IncrementalClassHierarchy(hierarchy);
        this.mtable = new MethodLookupTable(mtable);
        for (Type t : hierarchy) {
            if (mtable.containsKey(t)) continue;
            throw new IllegalArgumentException();
        }
        this.initializeClosures();
    }

    private final void initializeClosures() {
        for (Type t : MethodDeclarations.topologicalOrder(this.hierarchy)) {
            Type iface2;
            HashSet direct = new HashSet((Collection)this.mtable.get(t));
            Iterator it = direct.iterator();
            while (it.hasNext()) {
                MethodSignature m = (MethodSignature)it.next();
                if (!m.isPrivate()) continue;
                it.remove();
            }
            assert (direct != null);
            if (this.hierarchy.isInterface(t)) {
                HashSet closure = new HashSet(direct);
                for (Type iface2 : this.hierarchy.getInterfaces(t)) {
                    assert (this.pending.get(iface2) != null) : iface2;
                    closure.addAll(this.pending.get(iface2));
                }
                this.pending.put(t, closure);
                continue;
            }
            HashSet impl = new HashSet();
            HashSet<MethodSignature> pend = new HashSet<MethodSignature>();
            iface2 = direct.iterator();
            while (iface2.hasNext()) {
                MethodSignature m = (MethodSignature)iface2.next();
                (m.isAbstract() ? pend : impl).add(m);
            }
            this.implemented.put(t, impl);
            this.pending.put(t, pend);
            Type sc = this.hierarchy.getSuperclass(t);
            if (sc != null) {
                for (MethodSignature m : this.pending.get(sc)) {
                    this.addPending(t, m);
                }
                for (MethodSignature m : this.implemented.get(sc)) {
                    this.addImplemented(t, m);
                }
            }
            for (Type iface3 : this.hierarchy.getInterfaces(t)) {
                for (MethodSignature m : this.pending.get(iface3)) {
                    this.addPending(t, m);
                }
            }
        }
    }

    private boolean addImplemented(Type type, MethodSignature method) {
        if (!this.pending.get(type).contains(method)) {
            return this.implemented.get(type).add(method);
        }
        return false;
    }

    private boolean addPending(Type type, MethodSignature method) {
        if (!this.pending.get(type).contains(method)) {
            return this.implemented.get(type).add(method);
        }
        return false;
    }

    public Set<MethodSignature> getPending(Type type) {
        return this.pending.get(type);
    }

    public Set<MethodSignature> getImplemented(Type type) {
        return this.implemented.get(type);
    }

    private static List<Type> topologicalOrder(ClassHierarchy hierarchy) {
        Node root = Node.get(OBJECT);
        DirectedGraph<Node, DefaultEdge> graph = new GraphConverter(hierarchy).convert();
        ArrayList<Type> order = new ArrayList<Type>();
        HashSet<Node> unconstrained = new HashSet<Node>();
        unconstrained.add(root);
        while (!unconstrained.isEmpty()) {
            Node n = (Node)unconstrained.iterator().next();
            unconstrained.remove(n);
            order.add(n.asType());
            for (Node m : Graphs.predecessorListOf(graph, (Object)n)) {
                graph.removeEdge((Object)m, (Object)n);
                if (graph.outDegreeOf((Object)m) != 0) continue;
                unconstrained.add(m);
            }
        }
        if (!graph.edgeSet().isEmpty()) {
            throw new AssertionError();
        }
        return order;
    }
}

