/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier.graph;

import org.clyze.jphantom.Types;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.CyclicHierarchyException;
import org.clyze.jphantom.hier.graph.Node;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.objectweb.asm.Type;

public class GraphConverter
implements Types {
    private final ClassHierarchy hierarchy;

    public GraphConverter(ClassHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public DirectedGraph<Node, DefaultEdge> convert() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        for (Type t : this.hierarchy) {
            graph.addVertex((Object)Node.get(t));
        }
        for (Type t : this.hierarchy) {
            for (Type i : this.hierarchy.getInterfaces(t)) {
                graph.addVertex((Object)Node.get(i));
                graph.addEdge((Object)Node.get(t), (Object)Node.get(i));
            }
            Type sc = this.hierarchy.getSuperclass(t);
            if (sc == null) {
                assert (t.equals((Object)OBJECT)) : t;
                continue;
            }
            graph.addVertex((Object)Node.get(sc));
            graph.addEdge((Object)Node.get(t), (Object)Node.get(sc));
        }
        if (new CycleDetector((DirectedGraph)graph).detectCycles()) {
            throw new CyclicHierarchyException(graph.toString());
        }
        return graph;
    }
}

