/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.hier.AbstractClassHierarchy;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.objectweb.asm.Type;

public class IncrementalClassHierarchy
extends AbstractClassHierarchy
implements Types {
    private final Map<Type, Type> directSuperclass = new HashMap<Type, Type>();
    private final Map<Type, Set<Type>> directImplInterfaces = new HashMap<Type, Set<Type>>();
    private final Map<Type, Boolean> isIface = new HashMap<Type, Boolean>();

    public IncrementalClassHierarchy() {
        this.directSuperclass.put(OBJECT, null);
        this.directImplInterfaces.put(OBJECT, Collections.emptySet());
        this.isIface.put(OBJECT, false);
    }

    public IncrementalClassHierarchy(ClassHierarchy other) {
        this();
        for (Type t : other) {
            this.isIface.put(t, other.isInterface(t));
            Set<Type> ifaces = Collections.unmodifiableSet(other.getInterfaces(t));
            this.directSuperclass.put(t, other.getSuperclass(t));
            this.directImplInterfaces.put(t, ifaces);
        }
    }

    @Override
    public Iterator<Type> iterator() {
        return this.isIface.keySet().iterator();
    }

    private final void addSupertypes(Type clazz, Type superclass, Type[] interfaces) {
        Set<Type> ifaces = Collections.unmodifiableSet(new HashSet<Type>(Arrays.asList(interfaces)));
        assert (!ifaces.contains(null));
        assert (superclass != null || clazz.equals((Object)OBJECT)) : clazz;
        this.directImplInterfaces.put(clazz, ifaces);
        this.directSuperclass.put(clazz, superclass);
    }

    @Override
    public void addClass(Type clazz, Type superclass, Type[] interfaces) {
        if (this.contains(clazz)) {
            throw new IllegalArgumentException(clazz + " has already been added");
        }
        for (Type i : interfaces) {
            this.checkedInterface(i);
        }
        this.checkedClass(superclass);
        this.isIface.put(clazz, false);
        this.addSupertypes(clazz, superclass, interfaces);
    }

    @Override
    public void addInterface(Type iface, Type[] superInterfaces) {
        if (this.contains(iface)) {
            throw new IllegalArgumentException(iface + " has already been added");
        }
        for (Type i : superInterfaces) {
            this.checkedInterface(i);
        }
        this.isIface.put(iface, true);
        this.addSupertypes(iface, OBJECT, superInterfaces);
    }

    @Override
    public final boolean isInterface(Type obj) {
        return this.isIface.get(this.checkedContainedObject(obj));
    }

    @Override
    public final boolean contains(Type obj) {
        return this.isIface.containsKey(IncrementalClassHierarchy.checkedObject(obj));
    }

    @Override
    public Set<Type> getInterfaces(Type obj) {
        Set<Type> ifaces = this.directImplInterfaces.get(this.checkedContainedObject(obj));
        assert (ifaces != null) : obj;
        return ifaces;
    }

    @Override
    public Type getSuperclass(Type obj) {
        Type superclass = this.directSuperclass.get(this.checkedContainedObject(obj));
        assert (superclass != null || obj.equals((Object)OBJECT)) : obj;
        assert (!this.isInterface(obj) || superclass.equals((Object)OBJECT));
        return superclass;
    }
}

