/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.fields;

import org.clyze.jphantom.Signature;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;

public class FieldSignature
extends Signature {
    private final String name;
    private final String desc;

    private FieldSignature(Builder builder) {
        super(builder.access);
        this.name = builder.name;
        this.desc = builder.desc;
    }

    public Type getType() {
        return Type.getType((String)this.desc);
    }

    public String getDescriptor() {
        return this.desc;
    }

    @Override
    public String toStringAux() {
        StringBuilder builder = new StringBuilder();
        this.appendAccess(builder);
        builder.append(this.toString(this.getType()) + " " + this.name + "(");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldSignature)) {
            return false;
        }
        FieldSignature other = (FieldSignature)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static FieldSignature fromFieldNode(FieldNode node) {
        return new Builder(node.name, node.desc).access(node.access).build();
    }

    public static class Builder {
        private final String name;
        private final String desc;
        private int access = 0;

        public Builder(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public Builder access(int access) {
            this.access = access;
            return this;
        }

        public FieldSignature build() {
            return new FieldSignature(this);
        }
    }
}

