/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.dataflow;

import java.util.HashMap;
import java.util.Map;
import org.clyze.jphantom.ArrayTypes;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncompleteSupertypesException;
import org.clyze.jphantom.hier.closure.PseudoSnapshot;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class TypeInterpreter
extends BasicInterpreter
implements Opcodes,
Types {
    private static final Map<Type, BasicValue> values = new HashMap<Type, BasicValue>();
    protected static final BasicValue NULL_VALUE = new BasicValue(BasicInterpreter.NULL_TYPE);
    private ClassHierarchy.Snapshot closure;

    public TypeInterpreter(ClassHierarchy hier) {
        this(589824, hier);
    }

    public TypeInterpreter(int api, ClassHierarchy hier) {
        super(api);
        this.closure = new PseudoSnapshot(hier);
    }

    public static final BasicValue getValue(Type type) {
        if (!values.containsKey(type)) {
            values.put(type, new BasicValue(type));
        }
        return values.get(type);
    }

    public BasicValue newValue(Type type) {
        BasicValue val = super.newValue(type);
        return BasicValue.REFERENCE_VALUE.equals((Object)val) ? TypeInterpreter.getValue(type) : val;
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        if (insn.getOpcode() == 50) {
            if (value1.equals((Object)BasicValue.UNINITIALIZED_VALUE)) {
                return BasicValue.UNINITIALIZED_VALUE;
            }
            if (value1.equals((Object)NULL_VALUE)) {
                return NULL_VALUE;
            }
            return this.newValue(ArrayTypes.elementOf(value1.getType()));
        }
        return super.binaryOperation(insn, value1, value2);
    }

    public BasicValue merge(BasicValue v, BasicValue w) {
        if (v.equals((Object)w)) {
            return v;
        }
        if (!v.isReference() || !w.isReference()) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (v.equals((Object)NULL_VALUE)) {
            return w;
        }
        if (w.equals((Object)NULL_VALUE)) {
            return v;
        }
        Type a = v.getType();
        Type b = w.getType();
        if (a.getSort() == 9 && b.getSort() == 9 && a.getDimensions() == b.getDimensions()) {
            Type ae = a.getElementType();
            Type be = b.getElementType();
            if (ae.getSort() == 10 && be.getSort() == 10) {
                Type fcs;
                try {
                    fcs = this.closure.firstCommonSuperclass(ae, be);
                }
                catch (IncompleteSupertypesException exc) {
                    throw new IllegalStateException(exc);
                }
                return this.newValue(ArrayTypes.newType(fcs, a.getDimensions()));
            }
        }
        if (a.getSort() == 9 || b.getSort() == 9) {
            return this.newValue(OBJECT);
        }
        assert (a.getSort() == 10);
        assert (b.getSort() == 10);
        try {
            return this.newValue(this.closure.firstCommonSuperclass(a, b));
        }
        catch (IncompleteSupertypesException exc) {
            throw new IllegalStateException(exc);
        }
    }

    static {
        values.put(BasicInterpreter.NULL_TYPE, NULL_VALUE);
    }
}

