/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.constraints.solvers.MultipleInheritanceSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.jgrapht.DirectedGraph;

public abstract class LayeringSolver<V, E>
extends MultipleInheritanceSolver<V, E> {
    private final Set<E> special;
    private final Map<V, List<V>> projections;

    public LayeringSolver(DirectedGraph<V, E> graph, Set<E> special, Map<V, List<V>> projections, boolean minimize) {
        super(graph, minimize);
        for (E e : special) {
            if (!graph.containsEdge(e)) {
                throw new IllegalArgumentException();
            }
            Object source = graph.getEdgeSource(e);
            if (!projections.containsKey(source)) {
                throw new IllegalArgumentException("" + e);
            }
            if (!projections.get(source).isEmpty()) continue;
            throw new IllegalArgumentException("" + e);
        }
        this.special = special;
        this.projections = projections;
    }

    public final List<V> projectionsOf(V source) {
        return this.projections.get(source);
    }

    private Map<V, Integer> stratify(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        Iterator it;
        HashSet pathEdges = new HashSet(graph.edgeSet());
        HashSet specialEdges = new HashSet();
        HashSet<Object> next = graph.vertexSet();
        LinkedList<Set> strata = new LinkedList<Set>(Collections.singletonList(next));
        block0: while (true) {
            Object target;
            Object source;
            Object e2;
            HashSet<Object> prev = next;
            next = new HashSet<Object>();
            strata.add(next);
            for (Object e2 : Iterables.concat(pathEdges, specialEdges)) {
                next.add(graph.getEdgeTarget(e2));
            }
            if (next.isEmpty()) break;
            if (next.size() == prev.size()) {
                throw new Solver.UnsatisfiableStateException();
            }
            assert (next.size() < prev.size());
            it = pathEdges.iterator();
            while (it.hasNext()) {
                e2 = it.next();
                source = graph.getEdgeSource(e2);
                target = graph.getEdgeTarget(e2);
                if (next.contains(source)) {
                    assert (next.contains(target));
                    continue;
                }
                it.remove();
                if (!this.special.contains(e2)) continue;
                specialEdges.add(e2);
            }
            it = specialEdges.iterator();
            block3: while (true) {
                Object proj;
                if (!it.hasNext()) continue block0;
                e2 = it.next();
                source = graph.getEdgeSource(e2);
                target = graph.getEdgeTarget(e2);
                Iterator<Object> iterator = this.projectionsOf(source).iterator();
                do {
                    if (!iterator.hasNext()) continue block3;
                } while (next.contains(proj = iterator.next()));
                it.remove();
            }
            break;
        }
        HashMap strataValues = new HashMap();
        it = strata.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            Set stratum = (Set)it.next();
            for (Object v : stratum) {
                strataValues.put(v, i);
            }
        }
        for (Object v : graph.vertexSet()) {
            assert (strataValues.containsKey(v));
        }
        return strataValues;
    }

    @Override
    public void addConstraintEdge(V source, V target) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void solve(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        Map<V, Integer> strata = this.stratify(graph);
        block0: for (E e : this.special) {
            Object source = graph.getEdgeSource(e);
            Object target = graph.getEdgeTarget(e);
            for (Object proj : this.projectionsOf(source)) {
                int tStratum;
                int pStratum = strata.get(proj);
                if (pStratum >= (tStratum = strata.get(target).intValue())) continue;
                graph.removeEdge(source, target);
                graph.addEdge(proj, target);
                continue block0;
            }
            throw new AssertionError();
        }
        super.solve(graph);
    }
}

