/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.value.simulated;

import java.util.List;
import me.coley.analysis.StaticInvokeFactory;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.exception.SimFailedException;
import me.coley.analysis.util.GetSet;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.simulated.AbstractSimulatedValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class ReflectionSimulatedValue
extends AbstractSimulatedValue<Object> {
    protected ReflectionSimulatedValue(List<AbstractInsnNode> insns, Type type, Object value, TypeChecker typeChecker) {
        super(insns, type, value, typeChecker);
    }

    protected ReflectionSimulatedValue(List<AbstractInsnNode> insns, Type type, Object value, GetSet<Object> resultValue, TypeChecker typeChecker) {
        super(insns, type, value, resultValue, typeChecker);
    }

    @Override
    protected AbstractValue create(List<AbstractInsnNode> collection) {
        return new ReflectionSimulatedValue(collection, this.getType(), this.getValue(), this.resultValue, this.typeChecker);
    }

    public static AbstractValue ofStaticInvoke(StaticInvokeFactory factory, MethodInsnNode insn, List<? extends AbstractValue> arguments, TypeChecker typeChecker) throws SimFailedException {
        String owner = insn.owner;
        String name = insn.name;
        String desc = insn.desc;
        if (factory != null) {
            return factory.invokeStatic(insn, arguments);
        }
        if (!ReflectionSimulatedValue.isStaticMethodWhitelisted(owner, name, desc)) {
            throw new SimFailedException(insn, "Static method is not whitelisted.");
        }
        try {
            return ReflectionSimulatedValue.invokeStatic(insn, owner, name, Type.getMethodType((String)desc), arguments, typeChecker);
        }
        catch (Throwable t) {
            throw new SimFailedException(insn, "Failed to invoke method", t);
        }
    }

    @Override
    public AbstractValue ofVirtualInvoke(MethodInsnNode min, List<? extends AbstractValue> arguments) throws SimFailedException {
        return this.defaultOfVirtualInvoke(min, arguments);
    }
}

