/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.value.simulated;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.exception.SimFailedException;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.util.GetSet;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.PrimitiveValue;
import me.coley.analysis.value.VirtualValue;
import me.coley.analysis.value.simulated.ReflectionSimulatedValue;
import me.coley.analysis.value.simulated.StringSimulatedValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public abstract class AbstractSimulatedValue<T>
extends VirtualValue {
    private static final Map<String, BiFunction<List<AbstractInsnNode>, TypeChecker, AbstractSimulatedValue<?>>> TYPE_PRODUCERS = new HashMap();
    protected static final String[][] BLACKLISTED_METHODS = new String[][]{{"wait", "()V"}, {"wait", "(J)V"}, {"wait", "(JI)V"}, {"notify", "()V"}, {"notifyAll", "()V"}, {"intern", "()Ljava/lang/String;"}};
    protected static final Set<String> WHITELISTED_CLASSES = new HashSet<String>(Arrays.asList("java/lang/Long", "java/lang/Integer", "java/lang/Short", "java/lang/Character", "java/lang/Byte", "java/lang/Boolean", "java/lang/Float", "java/lang/Double", "java/lang/Math"));
    protected final GetSet<T> resultValue;

    protected AbstractSimulatedValue(List<AbstractInsnNode> insns, Type type, T value, TypeChecker typeChecker) {
        this(insns, type, value, new GetSet<T>(value), typeChecker);
    }

    protected AbstractSimulatedValue(List<AbstractInsnNode> insns, Type type, T value, GetSet<T> resultValue, TypeChecker typeChecker) {
        super(insns, type, AbstractSimulatedValue.copyValue(value), typeChecker);
        this.resultValue = resultValue;
    }

    @Override
    public boolean isValueResolved() {
        return this.value != null;
    }

    public T getResultValue() {
        return this.resultValue.get();
    }

    public void updateResultValue(T value) {
        this.resultValue.set(value);
    }

    public abstract AbstractValue ofVirtualInvoke(MethodInsnNode var1, List<? extends AbstractValue> var2) throws SimFailedException;

    protected AbstractValue defaultOfVirtualInvoke(MethodInsnNode min, List<? extends AbstractValue> arguments) throws SimFailedException {
        if (this.isNull()) {
            throw new SimFailedException(min, "Cannot act on null reference value");
        }
        if (this.isPrimitive()) {
            throw new SimFailedException(min, "Cannot act on a primitive");
        }
        Type desc = Type.getMethodType((String)min.desc);
        if (this.value == null) {
            throw new SimFailedException(min, "Context is null");
        }
        if (arguments.stream().anyMatch(AbstractValue::isValueUnresolved)) {
            throw new SimFailedException(min, "One or more arguments are not resolved");
        }
        try {
            return this.invokeVirtual(min, min.name, desc, arguments, this.resultValue.get());
        }
        catch (Throwable t) {
            throw new SimFailedException(min, "Failed to invoke method", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractValue invokeVirtual(MethodInsnNode min, String name, Type desc, List<? extends AbstractValue> arguments, Object invokeHost) throws ReflectiveOperationException {
        void var10_15;
        Type[] argTypes = desc.getArgumentTypes();
        if (name.equals("<init>")) {
            for (String[] stringArray : invokeHost.getClass().getConstructors()) {
                if (stringArray.getParameterCount() != argTypes.length) continue;
                boolean argsMatch = true;
                for (int i = 0; i < argTypes.length; ++i) {
                    argsMatch &= argTypes[i].equals((Object)Type.getType(stringArray.getParameterTypes()[i]));
                }
                if (!argsMatch) continue;
                List<MethodInsnNode> insns = CollectUtils.distinct(CollectUtils.combineAdd(arguments.stream().flatMap(arg -> arg.getInsns().stream()).collect(Collectors.toList()), this.getInsns(), min));
                Object[] argValues = arguments.stream().map(AbstractValue::getValue).toArray();
                stringArray.setAccessible(true);
                Object retVal = stringArray.newInstance(argValues);
                return new ReflectionSimulatedValue((List<AbstractInsnNode>)insns, Type.getType(retVal.getClass()), retVal, this.typeChecker);
            }
        }
        for (String[] stringArray : BLACKLISTED_METHODS) {
            if (!stringArray[0].equals(name) || !stringArray[1].equals(desc.getDescriptor())) continue;
            return new ReflectionSimulatedValue((List<AbstractInsnNode>)this.insns, this.getType(), this.getValue(), this.typeChecker);
        }
        Type retType = desc.getReturnType();
        Method[] methodArray = invokeHost.getClass().getMethods();
        int n = methodArray.length;
        boolean bl = false;
        while (var10_15 < n) {
            Method mm = methodArray[var10_15];
            if (mm.getName().equals(name) && mm.getParameterCount() == argTypes.length && !AbstractSimulatedValue.isStatic(mm.getModifiers())) {
                boolean argsMatch = true;
                for (int i = 0; i < argTypes.length; ++i) {
                    argsMatch &= argTypes[i].equals((Object)Type.getType(mm.getParameterTypes()[i]));
                }
                if (argsMatch) {
                    Object[] argValues = arguments.stream().map(AbstractValue::getValue).toArray();
                    mm.setAccessible(true);
                    Object retVal = mm.invoke(invokeHost, argValues);
                    if (retType.getSort() == 0) {
                        return null;
                    }
                    if (retVal != null) {
                        List<MethodInsnNode> insns = CollectUtils.distinct(CollectUtils.combineAdd(arguments.stream().flatMap(arg -> arg.getInsns().stream()).collect(Collectors.toList()), this.getInsns(), min));
                        if (TypeUtil.isPrimitiveDesc(retType.getDescriptor())) {
                            return AbstractSimulatedValue.unboxed(insns, retVal);
                        }
                        return new ReflectionSimulatedValue((List<AbstractInsnNode>)insns, Type.getType(retVal.getClass()), retVal, this.resultValue, this.typeChecker);
                    }
                }
            }
            ++var10_15;
        }
        throw new IllegalStateException("Could not find method to simulate: " + this.type.getInternalName() + "." + name + desc);
    }

    protected static AbstractValue invokeStatic(MethodInsnNode min, String owner, String name, Type desc, List<? extends AbstractValue> arguments, TypeChecker typeChecker) throws ReflectiveOperationException {
        Class<?> cls = Class.forName(owner.replace('/', '.'));
        Type retType = desc.getReturnType();
        Type[] argTypes = desc.getArgumentTypes();
        for (Method mm : cls.getMethods()) {
            if (!mm.getName().equals(name) || mm.getParameterCount() != argTypes.length || !AbstractSimulatedValue.isStatic(mm.getModifiers())) continue;
            boolean argsMatch = true;
            for (int i = 0; i < argTypes.length; ++i) {
                argsMatch &= argTypes[i].equals((Object)Type.getType(mm.getParameterTypes()[i]));
            }
            if (!argsMatch) continue;
            Object[] argValues = arguments.stream().map(AbstractValue::getValue).toArray();
            mm.setAccessible(true);
            Object retVal = mm.invoke(null, argValues);
            if (retType.getSort() == 0) {
                return null;
            }
            if (retVal == null) continue;
            List<MethodInsnNode> insns = CollectUtils.distinct(CollectUtils.add(arguments.stream().flatMap(arg -> arg.getInsns().stream()).collect(Collectors.toList()), min));
            if (TypeUtil.isPrimitiveDesc(retType.getDescriptor())) {
                return AbstractSimulatedValue.unboxed(insns, retVal);
            }
            return new ReflectionSimulatedValue((List<AbstractInsnNode>)insns, Type.getType(retVal.getClass()), retVal, typeChecker);
        }
        throw new IllegalStateException("Could not find method to simulate: " + owner + "." + name + desc);
    }

    protected static boolean isStaticMethodWhitelisted(String owner, String name, String desc) {
        return WHITELISTED_CLASSES.contains(owner);
    }

    protected static boolean isStatic(int modifiers) {
        return (modifiers & 8) == 8;
    }

    protected static AbstractValue unboxed(List<AbstractInsnNode> insns, Object retVal) {
        if (retVal instanceof Integer || retVal instanceof Short || retVal instanceof Byte) {
            return PrimitiveValue.ofInt(insns, ((Number)retVal).intValue());
        }
        if (retVal instanceof Float) {
            return PrimitiveValue.ofFloat(insns, ((Float)retVal).floatValue());
        }
        if (retVal instanceof Double) {
            return PrimitiveValue.ofDouble(insns, (double)((Double)retVal));
        }
        if (retVal instanceof Boolean) {
            return PrimitiveValue.ofInt(insns, (Boolean)retVal != false ? 1 : 0);
        }
        if (retVal instanceof Character) {
            return PrimitiveValue.ofChar(insns, ((Character)retVal).charValue());
        }
        if (retVal instanceof Long) {
            return PrimitiveValue.ofLong(insns, (long)((Long)retVal));
        }
        throw new UnsupportedOperationException("Unsupported boxed type: " + retVal.getClass().getName());
    }

    protected static Object copyValue(Object value) {
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof StringBuilder) {
            return new StringBuilder(value.toString());
        }
        if (value instanceof StringBuffer) {
            return new StringBuffer(value.toString());
        }
        throw new UnsupportedOperationException(value.getClass() + " copying not supported");
    }

    public static boolean supported(Type type) {
        return TYPE_PRODUCERS.containsKey(type.getInternalName());
    }

    public static <T> AbstractSimulatedValue<T> initialize(List<AbstractInsnNode> insns, TypeChecker typeChecker, Type type) {
        return TYPE_PRODUCERS.get(type.getInternalName()).apply(insns, typeChecker);
    }

    static {
        TYPE_PRODUCERS.put("java/lang/StringBuilder", (insns, typeChecker) -> new ReflectionSimulatedValue((List<AbstractInsnNode>)insns, Type.getObjectType((String)"java/lang/StringBuilder"), (Object)new StringBuilder(), (TypeChecker)typeChecker));
        TYPE_PRODUCERS.put("java/lang/StringBuffer", (insns, typeChecker) -> new ReflectionSimulatedValue((List<AbstractInsnNode>)insns, Type.getObjectType((String)"java/lang/StringBuffer"), (Object)new StringBuffer(), (TypeChecker)typeChecker));
        TYPE_PRODUCERS.put("java/lang/String", (insns, typeChecker) -> StringSimulatedValue.of(insns, typeChecker, ""));
    }
}

