/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.NullConstantValue;
import me.coley.analysis.value.PrimitiveValue;
import me.coley.analysis.value.ReturnAddressValue;
import me.coley.analysis.value.UninitializedValue;
import me.coley.analysis.value.VirtualValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.analysis.Value;

public abstract class AbstractValue
implements Value {
    protected final Type type;
    protected final Object value;
    protected final List<AbstractInsnNode> insns;
    private JumpInsnNode nullCheck;
    private AbstractValue copySource;

    protected AbstractValue(AbstractInsnNode insn, Type type, Object value) {
        this(insn == null ? new ArrayList() : CollectUtils.of(insn), type, value);
    }

    protected AbstractValue(List<AbstractInsnNode> insns, Type type, Object value) {
        if (insns == null) {
            insns = new ArrayList<AbstractInsnNode>();
        }
        this.insns = insns;
        if (type == null && value != null) {
            throw new IllegalStateException("Analyzer value wrapper was given a value but no type information");
        }
        if (type != null && type.getSort() >= 1 && type.getSort() < 5) {
            type = Type.INT_TYPE;
        }
        this.type = type;
        this.value = value;
    }

    protected abstract AbstractValue create(List<AbstractInsnNode> var1);

    public static AbstractValue ofDefault(AbstractInsnNode insn, TypeChecker typeChecker, Type type) {
        if (type == null) {
            return UninitializedValue.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return PrimitiveValue.ofInt(insn, 0);
            }
            case 6: {
                return PrimitiveValue.ofFloat(insn, 0.0f);
            }
            case 7: {
                return PrimitiveValue.ofLong(insn, 0L);
            }
            case 8: {
                return PrimitiveValue.ofDouble(insn, 0.0);
            }
            case 9: 
            case 10: {
                if (type.equals((Object)NullConstantValue.NULL_VALUE_TYPE)) {
                    return NullConstantValue.newNull(insn);
                }
                return new VirtualValue(insn, type, null, typeChecker);
            }
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    public final <A extends AbstractValue> A copy(AbstractInsnNode insn) {
        AbstractValue copy = this.create(CollectUtils.add(this.getInsns(), insn));
        copy.setNullCheckedBy(this.getNullCheck());
        copy.copySource = this;
        return (A)copy;
    }

    public abstract boolean canMerge(AbstractValue var1);

    public abstract boolean isPrimitive();

    public boolean isWide() {
        return this.isPrimitive() && this.getType().getSize() == 2;
    }

    public abstract boolean isReference();

    public abstract boolean isValueResolved();

    public boolean isValueUnresolved() {
        return !this.isValueResolved();
    }

    public boolean isNull() {
        return !this.isPrimitive() && this.value == null;
    }

    public boolean isArray() {
        return this.type != null && this.type.getSort() == 9;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public List<AbstractInsnNode> getInsns() {
        return Collections.unmodifiableList(this.insns);
    }

    public void addContributing(AbstractInsnNode contributing) {
        if (!this.insns.contains(contributing)) {
            this.insns.add(contributing);
        }
    }

    public void addContributing(Collection<AbstractInsnNode> contributing) {
        contributing = new ArrayList<AbstractInsnNode>(contributing);
        contributing.removeAll(this.insns);
        this.insns.addAll(contributing);
    }

    public void setNullCheckedBy(JumpInsnNode nullCheck) {
        this.nullCheck = nullCheck;
        if (this.copySource != null) {
            this.copySource.setNullCheckedBy(nullCheck);
        }
    }

    public JumpInsnNode getNullCheck() {
        return this.nullCheck;
    }

    public int getSize() {
        if (this.type == null) {
            return 1;
        }
        return TypeUtil.sortToSize(this.type.getSort());
    }

    public int hashCode() {
        if (this.type == null) {
            return 0;
        }
        if (this.value == null) {
            return this.type.hashCode();
        }
        return Objects.hash(this.type.getDescriptor(), this.value);
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        if (this == UninitializedValue.UNINITIALIZED_VALUE) {
            return "<UNINIT>";
        }
        if (this instanceof NullConstantValue) {
            return "<NULL>";
        }
        if (this instanceof ReturnAddressValue) {
            return "<JSR_RET>";
        }
        if (this.isNull()) {
            return "<" + this.type + ":NULL>";
        }
        if (this.isValueResolved()) {
            return "<" + this.type + ":" + this.value + ">";
        }
        return "<" + this.type + ">";
    }
}

