/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.UninitializedValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class SimFrame
extends Frame<AbstractValue> {
    private final Set<Integer> reservedSlots = new HashSet<Integer>();
    private final Set<SimFrame> flowInputs = new HashSet<SimFrame>();
    private final Set<SimFrame> flowOutputs = new HashSet<SimFrame>();
    private AbstractInsnNode instruction;

    public SimFrame(int numLocals, int numStack) {
        super(numLocals, numStack);
    }

    public SimFrame(SimFrame frame) {
        super((Frame)frame);
    }

    public void execute(AbstractInsnNode insn, Interpreter<AbstractValue> interpreter) throws AnalyzerException {
        if (insn.getOpcode() == 95) {
            AbstractValue value2 = (AbstractValue)this.pop();
            AbstractValue value1 = (AbstractValue)this.pop();
            if (value1.getSize() != 1 || value2.getSize() != 1) {
                throw new AnalyzerException(insn, "Illegal use of SWAP");
            }
            value2 = value2.copy(insn);
            value1 = value1.copy(insn);
            List<AbstractInsnNode> addTo1 = CollectUtils.disjoint(value2.getInsns(), value1.getInsns());
            List<AbstractInsnNode> addTo2 = CollectUtils.disjoint(value1.getInsns(), value2.getInsns());
            value1.addContributing(addTo1);
            value2.addContributing(addTo2);
            this.push(value2);
            this.push(value1);
        } else if (insn.getOpcode() == 89) {
            AbstractValue value1 = (AbstractValue)this.pop();
            if (value1.getSize() != 1) {
                throw new AnalyzerException(insn, "Illegal use of DUP");
            }
            this.push((Value)value1.copy(insn));
            this.push((Value)value1.copy(insn));
        } else {
            super.execute(insn, interpreter);
            if (insn.getOpcode() == 183) {
                AbstractValue ownerValue;
                MethodInsnNode min = (MethodInsnNode)insn;
                if (min.name.equals("<init>") && (ownerValue = (AbstractValue)this.getStack(this.getStackSize() - 1)).isReference() && min.owner.equals(ownerValue.getType().getInternalName())) {
                    ownerValue.addContributing((AbstractInsnNode)min);
                }
            }
        }
    }

    public void setLocal(int index, AbstractValue value) {
        if (value != UninitializedValue.UNINITIALIZED_VALUE) {
            if (this.reservedSlots.contains(index)) {
                throw new IllegalStateException("Cannot set local[" + index + "] since it is reserved by a double/long (which reserves two slots)");
            }
            if (value.getValue() instanceof Double || value.getValue() instanceof Long) {
                this.reservedSlots.add(index + 1);
            }
        }
        super.setLocal(index, (Value)value);
    }

    public void initJumpTarget(int opcode, LabelNode target) {
        this.reservedSlots.clear();
    }

    public AbstractInsnNode getInstruction() {
        return this.instruction;
    }

    public Set<SimFrame> getFlowInputs() {
        return this.flowInputs;
    }

    public Set<SimFrame> getFlowOutputs() {
        return this.flowOutputs;
    }

    public void setInstruction(AbstractInsnNode instruction) {
        this.instruction = instruction;
    }

    public void flowsInto(SimFrame to) {
        this.flowOutputs.add(to);
        to.flowInputs.add(this);
    }
}

