/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.value;

import java.util.List;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.Unresolved;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.NullConstantValue;
import me.coley.analysis.value.PrimitiveValue;
import me.coley.analysis.value.UninitializedValue;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public class VirtualValue
extends AbstractValue {
    protected final TypeChecker typeChecker;

    protected VirtualValue(AbstractInsnNode insn, Type type, Object value, TypeChecker typeChecker) {
        super(insn, type, value);
        this.typeChecker = typeChecker;
    }

    protected VirtualValue(List<AbstractInsnNode> insns, Type type, Object value, TypeChecker typeChecker) {
        super(insns, type, value);
        this.typeChecker = typeChecker;
    }

    public static VirtualValue ofVirtual(AbstractInsnNode insn, TypeChecker typeChecker, Type type) {
        return new VirtualValue(insn, type, (Object)new Unresolved(type), typeChecker);
    }

    public static VirtualValue ofVirtual(List<AbstractInsnNode> insns, TypeChecker typeChecker, Type type) {
        return new VirtualValue(insns, type, (Object)new Unresolved(type), typeChecker);
    }

    public static VirtualValue ofClass(AbstractInsnNode insn, TypeChecker typeChecker, Type value) {
        return new VirtualValue(insn, Type.getObjectType((String)"java/lang/Class"), (Object)value, typeChecker);
    }

    public AbstractValue ofMethodRef(AbstractInsnNode insn, TypeChecker typeChecker, Type desc) {
        if (desc == null) {
            throw new IllegalStateException("Method descriptor must not be null");
        }
        if (this.value == null || this.value.equals(Type.VOID_TYPE)) {
            throw new IllegalStateException("Cannot act on null reference value");
        }
        if (!this.isReference()) {
            throw new IllegalStateException("Cannot act on reference on non-reference value");
        }
        Type retType = desc.getReturnType();
        if (retType.equals((Object)Type.VOID_TYPE)) {
            return null;
        }
        if (retType.getSort() <= 8) {
            return new PrimitiveValue(insn, retType);
        }
        return VirtualValue.ofVirtual(insn, typeChecker, retType);
    }

    @Override
    public AbstractValue copy(AbstractInsnNode insn) {
        return this.onCopy(new VirtualValue(CollectUtils.add(this.getInsns(), insn), this.getType(), this.getValue(), this.typeChecker));
    }

    @Override
    public boolean canMerge(AbstractValue other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NullConstantValue || other == UninitializedValue.UNINITIALIZED_VALUE || other == null) {
            return false;
        }
        if (this.type == null) {
            return other.type == null;
        }
        return this.type.equals((Object)other.type) || this.isParent(this.type, other.type);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean isValueResolved() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == UninitializedValue.UNINITIALIZED_VALUE) {
            return false;
        }
        if (other instanceof NullConstantValue) {
            return false;
        }
        if (other instanceof VirtualValue) {
            VirtualValue rOther = (VirtualValue)other;
            if (this.value instanceof StringBuilder || this.value instanceof StringBuffer) {
                return this.value.toString().equals(rOther.value.toString());
            }
            return this.type.equals((Object)rOther.type) && this.value.equals(rOther.value);
        }
        return false;
    }

    protected boolean isParent(Type parent, Type child) {
        if (parent == null || child == null) {
            throw new IllegalStateException("Cannot find common type of parent null type");
        }
        if (parent.equals((Object)child)) {
            return true;
        }
        if (parent.getSort() == 10 && child.getSort() == 10) {
            if (parent.equals((Object)child)) {
                return true;
            }
            return this.typeChecker.test(parent, child);
        }
        return parent.getSort() < 9 && child.getSort() < 9;
    }
}

