/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis;

import java.util.HashSet;
import java.util.Set;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.UninitializedValue;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class SimFrame
extends Frame<AbstractValue> {
    private final Set<Integer> reservedSlots = new HashSet<Integer>();

    public SimFrame(int numLocals, int numStack) {
        super(numLocals, numStack);
    }

    public SimFrame(SimFrame frame) {
        super((Frame)frame);
    }

    public void setLocal(int index, AbstractValue value) {
        if (value != UninitializedValue.UNINITIALIZED_VALUE) {
            if (this.reservedSlots.contains(index)) {
                throw new IllegalStateException("Cannot set local[" + index + "] since it is reserved by a double/long (which reserves two slots)");
            }
            if (value.getValue() instanceof Double || value.getValue() instanceof Long) {
                this.reservedSlots.add(index + 1);
            }
        }
        super.setLocal(index, (Value)value);
    }

    public void initJumpTarget(int opcode, LabelNode target) {
        this.reservedSlots.clear();
    }

    public boolean merge(Frame<? extends AbstractValue> frame, Interpreter<AbstractValue> interpreter) throws AnalyzerException {
        return super.merge(frame, interpreter);
    }

    public boolean merge(Frame<? extends AbstractValue> frame, boolean[] localsUsed) {
        return super.merge(frame, localsUsed);
    }
}

