/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.util;

import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.classfile.annotation.ClassElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import software.coley.cafedude.classfile.annotation.Utf8ElementValue;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpDouble;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFloat;
import software.coley.cafedude.classfile.constant.CpInt;
import software.coley.cafedude.classfile.constant.CpLong;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpMethodType;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpString;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.Handle;

public class ConstantUtil {
    @Nonnull
    public static Constant from(@Nonnull CpEntry entry) {
        switch (entry.getTag()) {
            case 1: {
                return Constant.of(((CpUtf8)entry).getText());
            }
            case 8: {
                return ConstantUtil.from((CpEntry)((CpString)entry).getString());
            }
            case 3: {
                return Constant.of(((CpInt)entry).getValue());
            }
            case 4: {
                return Constant.of(((CpFloat)entry).getValue());
            }
            case 5: {
                return Constant.of(((CpLong)entry).getValue());
            }
            case 6: {
                return Constant.of(((CpDouble)entry).getValue());
            }
            case 7: {
                CpClass cpClass = (CpClass)entry;
                return Constant.of(Descriptor.from((String)('L' + cpClass.getName().getText() + ';')));
            }
            case 16: {
                CpMethodType cpMethodType = (CpMethodType)entry;
                return Constant.of(Descriptor.from((String)cpMethodType.getDescriptor().getText()));
            }
            case 15: {
                CpMethodHandle cpMethodHandle = (CpMethodHandle)entry;
                ConstRef ref = cpMethodHandle.getReference();
                CpNameType nt = ref.getNameType();
                String owner = ref.getClassRef().getName().getText();
                String name = nt.getName().getText();
                String desc = nt.getType().getText();
                return Constant.of(new Handle(Handle.Tag.fromKind(cpMethodHandle.getKind()), owner, name, Descriptor.from((String)desc)));
            }
        }
        throw new IllegalArgumentException("Non convertible constant type: " + entry.getTag());
    }

    @Nonnull
    public static Constant from(@Nonnull ElementValue value) {
        CpEntry cp;
        if (value instanceof PrimitiveElementValue) {
            PrimitiveElementValue primitive = (PrimitiveElementValue)value;
            cp = primitive.getValue();
        } else if (value instanceof Utf8ElementValue) {
            Utf8ElementValue utf8 = (Utf8ElementValue)value;
            cp = utf8.getValue();
        } else if (value instanceof ClassElementValue) {
            ClassElementValue clazz = (ClassElementValue)value;
            cp = clazz.getClassEntry();
        } else {
            throw new IllegalStateException("Unknown element value: " + value);
        }
        return ConstantUtil.from(cp);
    }
}

