/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.AnnotationElementValue;
import software.coley.cafedude.classfile.annotation.ArrayElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.EnumElementValue;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.visitor.AnnotationArrayVisitor;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.tree.visitor.writer.AnnotationArrayWriter;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class AnnotationWriter
implements AnnotationVisitor {
    private final Symbols symbols;
    private final Map<CpUtf8, ElementValue> values = new HashMap<CpUtf8, ElementValue>();
    private final Consumer<Map<CpUtf8, ElementValue>> callback;

    AnnotationWriter(Symbols symbols, Consumer<Map<CpUtf8, ElementValue>> callback) {
        this.callback = callback;
        this.symbols = symbols;
    }

    @Override
    public void visitValue(@Nonnull String key, @Nonnull Constant value) {
        this.values.put(this.symbols.newUtf8(key), this.symbols.newElementValue(value));
    }

    @Override
    public AnnotationVisitor visitAnnotation(@Nonnull String key, @Nonnull String type) {
        return new AnnotationWriter(this.symbols, values -> {
            Annotation anno = new Annotation(this.symbols.newUtf8(type), values);
            this.values.put(this.symbols.newUtf8(key), (ElementValue)new AnnotationElementValue('@', anno));
        });
    }

    @Override
    public AnnotationArrayVisitor visitArray(@Nonnull String key) {
        return new AnnotationArrayWriter(this.symbols, array -> this.values.put(this.symbols.newUtf8(key), (ElementValue)new ArrayElementValue('[', array)));
    }

    @Override
    public void visitEnum(@Nonnull String key, @Nonnull String type, @Nonnull String name) {
        this.values.put(this.symbols.newUtf8(key), (ElementValue)new EnumElementValue('e', this.symbols.newUtf8(type), this.symbols.newUtf8(name)));
    }

    @Override
    public void visitAnnotationEnd() {
        this.callback.accept(this.values);
    }
}

