/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.AnnotationElementValue;
import software.coley.cafedude.classfile.annotation.ArrayElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.EnumElementValue;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.visitor.AnnotationArrayVisitor;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.tree.visitor.writer.AnnotationWriter;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class AnnotationArrayWriter
implements AnnotationArrayVisitor {
    private final List<ElementValue> array = new ArrayList<ElementValue>();
    private final Symbols symbols;
    private final Consumer<List<ElementValue>> callback;

    AnnotationArrayWriter(@Nonnull Symbols symbols, @Nonnull Consumer<List<ElementValue>> callback) {
        this.callback = callback;
        this.symbols = symbols;
    }

    @Override
    public void visitArrayValue(@Nonnull Constant value) {
        this.array.add(this.symbols.newElementValue(value));
    }

    @Override
    public void visitArrayEnum(@Nonnull String type, @Nonnull String name) {
        this.array.add((ElementValue)new EnumElementValue('e', this.symbols.newUtf8(type), this.symbols.newUtf8(name)));
    }

    @Override
    public AnnotationVisitor visitArrayAnnotation(@Nonnull String type) {
        return new AnnotationWriter(this.symbols, values -> this.array.add((ElementValue)new AnnotationElementValue('@', new Annotation(this.symbols.newUtf8(type), values))));
    }

    @Override
    @Nullable
    public AnnotationArrayVisitor visitSubArray() {
        return new AnnotationArrayWriter(this.symbols, array -> this.array.add((ElementValue)new ArrayElementValue('[', array)));
    }

    @Override
    public void visitArrayEnd() {
        this.callback.accept(this.array);
    }
}

