/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.reader;

import java.util.List;
import javax.annotation.Nonnull;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import software.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleAttribute;
import software.coley.cafedude.classfile.attribute.ModuleMainClassAttribute;
import software.coley.cafedude.classfile.attribute.ModulePackagesAttribute;
import software.coley.cafedude.classfile.attribute.NestHostAttribute;
import software.coley.cafedude.classfile.attribute.NestMembersAttribute;
import software.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import software.coley.cafedude.classfile.attribute.RecordAttribute;
import software.coley.cafedude.classfile.attribute.SourceDebugExtensionAttribute;
import software.coley.cafedude.classfile.attribute.SourceFileAttribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.ClassFileReader;
import software.coley.cafedude.transform.LabelTransformer;
import software.coley.cafedude.tree.visitor.ClassVisitor;
import software.coley.cafedude.tree.visitor.ModuleVisitor;
import software.coley.cafedude.tree.visitor.RecordComponentVisitor;
import software.coley.cafedude.tree.visitor.reader.MemberReader;
import software.coley.cafedude.util.Optional;

public class ClassReader {
    private final ClassFile classFile;

    public ClassReader(@Nonnull byte[] bytes) throws InvalidClassException {
        ClassFileReader reader = new ClassFileReader();
        this.classFile = reader.read(bytes);
    }

    public ClassReader(@Nonnull ClassFile file) {
        this.classFile = file;
    }

    public void accept(@Nonnull ClassVisitor visitor) throws InvalidClassException {
        String version;
        int flags;
        String name;
        ModuleVisitor mv;
        ModuleAttribute module;
        RecordAttribute record;
        PermittedClassesAttribute permittedClasses;
        InnerClassesAttribute innerClasses;
        LabelTransformer transformer = new LabelTransformer(this.classFile);
        transformer.transform();
        List interfaces = this.classFile.getInterfaceClasses();
        String[] interfaceNames = new String[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            interfaceNames[i] = ((CpClass)interfaces.get(i)).getName().getText();
        }
        visitor.visitClass(this.classFile.getName(), this.classFile.getAccess(), this.classFile.getSuperName(), interfaceNames);
        MemberReader.visitDeclaration(visitor, (AttributeHolder)this.classFile);
        EnclosingMethodAttribute enclosingMethod = (EnclosingMethodAttribute)this.classFile.getAttribute(EnclosingMethodAttribute.class);
        if (enclosingMethod != null) {
            String owner = enclosingMethod.getClassEntry().getName().getText();
            Object name2 = null;
            Descriptor desc = null;
            if (enclosingMethod.getMethodEntry() != null) {
                CpNameType nameType = enclosingMethod.getMethodEntry();
                name2 = nameType.getName().getText();
                desc = Descriptor.from((String)nameType.getType().getText());
            }
            visitor.visitOuterClass(owner, (String)name2, desc);
        }
        if ((innerClasses = (InnerClassesAttribute)this.classFile.getAttribute(InnerClassesAttribute.class)) != null) {
            for (InnerClassesAttribute.InnerClass innerClass : innerClasses.getInnerClasses()) {
                String innerName = innerClass.getInnerClassInfo().getName().getText();
                String outerName = (String)Optional.orNull((Object)innerClass.getOuterClassInfo(), t -> t.getName().getText());
                String innerSimpleName = (String)Optional.orNull((Object)innerClass.getInnerName(), CpUtf8::getText);
                visitor.visitInnerClass(innerName, outerName, innerSimpleName, innerClass.getInnerClassAccessFlags());
            }
        }
        SourceFileAttribute sourceFile = (SourceFileAttribute)this.classFile.getAttribute(SourceFileAttribute.class);
        SourceDebugExtensionAttribute sourceDebug = (SourceDebugExtensionAttribute)this.classFile.getAttribute(SourceDebugExtensionAttribute.class);
        String source = (String)Optional.orNull((Object)sourceFile, t -> t.getSourceFilename().getText());
        byte[] debug = (byte[])Optional.orNull((Object)sourceDebug, SourceDebugExtensionAttribute::getDebugExtension);
        visitor.visitSource(source, debug);
        NestHostAttribute nestHost = (NestHostAttribute)this.classFile.getAttribute(NestHostAttribute.class);
        NestMembersAttribute nestMembers = (NestMembersAttribute)this.classFile.getAttribute(NestMembersAttribute.class);
        if (nestHost != null) {
            visitor.visitNestHost(nestHost.getHostClass().getName().getText());
        }
        if (nestMembers != null) {
            for (Object member : nestMembers.getMemberClasses()) {
                visitor.visitNestMember(member.getName().getText());
            }
        }
        if ((permittedClasses = (PermittedClassesAttribute)this.classFile.getAttribute(PermittedClassesAttribute.class)) != null) {
            for (Object permitted : permittedClasses.getClasses()) {
                visitor.visitPermittedSubclass(permitted.getName().getText());
            }
        }
        if ((record = (RecordAttribute)this.classFile.getAttribute(RecordAttribute.class)) != null) {
            for (RecordAttribute.RecordComponent component : record.getComponents()) {
                String type;
                String name3 = component.getName().getText();
                RecordComponentVisitor rcv = visitor.visitRecordComponent(name3, Descriptor.from((String)(type = component.getDesc().getText())));
                if (rcv == null) continue;
                MemberReader.visitDeclaration(rcv, (AttributeHolder)component);
                rcv.visitRecordComponentEnd();
            }
        }
        if ((module = (ModuleAttribute)this.classFile.getAttribute(ModuleAttribute.class)) != null && (mv = visitor.visitModule(name = module.getName().getText(), flags = module.getFlags(), version = (String)Optional.orNull((Object)module.getVersion(), CpUtf8::getText))) != null) {
            this.visitModule(mv, module);
            mv.visitModuleEnd();
        }
        MemberReader memberReader = new MemberReader(this.classFile, transformer);
        for (Method method : this.classFile.getMethods()) {
            memberReader.visitMethod(visitor.visitMethod(method.getName().getText(), method.getAccess(), Descriptor.from((String)method.getType().getText())), (AttributeHolder)method);
        }
        for (Field field : this.classFile.getFields()) {
            memberReader.visitField(visitor.visitField(field.getName().getText(), field.getAccess(), Descriptor.from((String)field.getType().getText())), (AttributeHolder)field);
        }
        visitor.visitClassEnd();
    }

    private void visitModule(@Nonnull ModuleVisitor visitor, @Nonnull ModuleAttribute module) {
        ModulePackagesAttribute packages;
        int i;
        String[] targets;
        int flags;
        String name;
        for (ModuleAttribute.Requires require : module.getRequires()) {
            name = require.getModule().getName().getText();
            flags = require.getFlags();
            visitor.visitRequires(name, flags, (String)Optional.orNull((Object)require.getVersion(), CpUtf8::getText));
        }
        for (ModuleAttribute.Exports export : module.getExports()) {
            name = export.getPackageEntry().getPackageName().getText();
            flags = export.getFlags();
            targets = new String[export.getTo().size()];
            i = 0;
            for (CpModule to : export.getTo()) {
                targets[i] = to.getName().getText();
                ++i;
            }
            visitor.visitExports(name, flags, targets);
        }
        for (ModuleAttribute.Opens open : module.getOpens()) {
            name = open.getPackageEntry().getPackageName().getText();
            flags = open.getFlags();
            targets = new String[open.getTo().size()];
            i = 0;
            for (CpModule to : open.getTo()) {
                targets[i] = to.getName().getText();
                ++i;
            }
            visitor.visitOpens(name, flags, targets);
        }
        for (CpClass use : module.getUses()) {
            visitor.visitUses(use.getName().getText());
        }
        for (ModuleAttribute.Provides provide : module.getProvides()) {
            name = provide.getModule().getName().getText();
            String[] targets2 = new String[provide.getWith().size()];
            int i2 = 0;
            for (CpClass with : provide.getWith()) {
                targets2[i2] = with.getName().getText();
                ++i2;
            }
            visitor.visitProvides(name, targets2);
        }
        ModuleMainClassAttribute mainClass = (ModuleMainClassAttribute)this.classFile.getAttribute(ModuleMainClassAttribute.class);
        if (mainClass != null) {
            visitor.visitMainClass(mainClass.getMainClass().getName().getText());
        }
        if ((packages = (ModulePackagesAttribute)this.classFile.getAttribute(ModulePackagesAttribute.class)) != null) {
            for (CpPackage pkg : packages.getPackages()) {
                visitor.visitPackage(pkg.getPackageName().getText());
            }
        }
    }
}

