/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.InvalidCodeException;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.Handle;
import software.coley.cafedude.tree.Label;
import software.coley.cafedude.tree.frame.Value;

public interface CodeVisitor {
    @Nullable
    default public CodeVisitor codeDelegate() {
        return null;
    }

    default public void visitFrame(int kind, @Nonnull Value[] locals, @Nonnull Value[] stack, int argument) {
        CodeVisitor delegate = this.codeDelegate();
        if (delegate != null) {
            delegate.visitFrame(kind, locals, stack, argument);
        }
    }

    default public void visitExceptionHandler(@Nullable String type, @Nonnull Label start, @Nonnull Label end, @Nonnull Label handler) {
        CodeVisitor delegate = this.codeDelegate();
        if (delegate != null) {
            delegate.visitExceptionHandler(type, start, end, handler);
        }
    }

    default public void visitNop() {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitNop();
        }
    }

    default public void visitThrow() {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitThrow();
        }
    }

    default public void visitMonitorInsn(int opcode) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitMonitorInsn(opcode);
        }
    }

    default public void visitReturnInsn(int opcode) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitReturnInsn(opcode);
        }
    }

    default public void visitConstantInsn(int opcode) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitConstantInsn(opcode);
        }
    }

    default public void visitArithmeticInsn(int opcode) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitArithmeticInsn(opcode);
        }
    }

    default public void visitArrayInsn(int opcode) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitArrayInsn(opcode);
        }
    }

    default public void visitStackInsn(int opcode) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitStackInsn(opcode);
        }
    }

    default public void visitLabel(@Nonnull Label label) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitLabel(label);
        }
    }

    default public void visitLineNumber(int line, @Nonnull Label start) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitLineNumber(line, start);
        }
    }

    default public void visitIntInsn(int opcode, int operand) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitIntInsn(opcode, operand);
        }
    }

    default public void visitVarInsn(int opcode, int var) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitVarInsn(opcode, var);
        }
    }

    default public void visitTypeInsn(int opcode, @Nonnull String type) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitTypeInsn(opcode, type);
        }
    }

    default public void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull Descriptor type) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitFieldInsn(opcode, owner, name, type);
        }
    }

    default public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull Descriptor descriptor) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitMethodInsn(opcode, owner, name, descriptor);
        }
    }

    default public void visitInvokeDynamicInsn(@Nonnull String name, @Nonnull Descriptor descriptor, @Nonnull Handle bootstrapMethod, Constant ... bootstrapArgs) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitInvokeDynamicInsn(name, descriptor, bootstrapMethod, bootstrapArgs);
        }
    }

    default public void visitFlowInsn(int opcode, @Nonnull Label label) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitFlowInsn(opcode, label);
        }
    }

    default public void visitLdcInsn(@Nonnull Constant constant) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitLdcInsn(constant);
        }
    }

    default public void visitIIncInsn(int var, int increment) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitIIncInsn(var, increment);
        }
    }

    default public void visitTableSwitchInsn(int min, int max, @Nonnull Label defaultLabel, Label ... labels) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitTableSwitchInsn(min, max, defaultLabel, labels);
        }
    }

    default public void visitLookupSwitchInsn(@Nonnull Label defaultLabel, int[] keys, Label ... labels) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitLookupSwitchInsn(defaultLabel, keys, labels);
        }
    }

    default public void visitMultiANewArrayInsn(@Nonnull String type, int dimensions) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitMultiANewArrayInsn(type, dimensions);
        }
    }

    default public void visitMaxs(int maxStack, int maxLocal) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitMaxs(maxStack, maxLocal);
        }
    }

    default public void visitLocalVariable(int index, @Nonnull String name, @Nonnull Descriptor descriptor, @Nullable String signature, @Nonnull Label start, @Nonnull Label end) {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitLocalVariable(index, name, descriptor, signature, start, end);
        }
    }

    default public void visitCodeEnd() throws InvalidCodeException {
        CodeVisitor cv = this.codeDelegate();
        if (cv != null) {
            cv.visitCodeEnd();
        }
    }
}

