/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.tree.Code;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.ExceptionHandler;
import software.coley.cafedude.tree.Handle;
import software.coley.cafedude.tree.Label;
import software.coley.cafedude.tree.Local;
import software.coley.cafedude.tree.insn.ArithmeticInsn;
import software.coley.cafedude.tree.insn.ArrayInsn;
import software.coley.cafedude.tree.insn.ConstantInsn;
import software.coley.cafedude.tree.insn.FieldInsn;
import software.coley.cafedude.tree.insn.FlowInsn;
import software.coley.cafedude.tree.insn.IIncInsn;
import software.coley.cafedude.tree.insn.Insn;
import software.coley.cafedude.tree.insn.IntInsn;
import software.coley.cafedude.tree.insn.InvokeDynamicInsn;
import software.coley.cafedude.tree.insn.LabelInsn;
import software.coley.cafedude.tree.insn.LdcInsn;
import software.coley.cafedude.tree.insn.LookupSwitchInsn;
import software.coley.cafedude.tree.insn.MethodInsn;
import software.coley.cafedude.tree.insn.MultiANewArrayInsn;
import software.coley.cafedude.tree.insn.ReturnInsn;
import software.coley.cafedude.tree.insn.StackInsn;
import software.coley.cafedude.tree.insn.TableSwitchInsn;
import software.coley.cafedude.tree.insn.TypeInsn;
import software.coley.cafedude.tree.insn.VarInsn;
import software.coley.cafedude.tree.visitor.CodeVisitor;

public class CodeDataVisitor
implements CodeVisitor {
    private final List<Insn> insns = new ArrayList<Insn>();
    private final List<Local> locals = new ArrayList<Local>();
    private final List<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>();
    private int maxStack;
    private int maxLocals;

    @Override
    public void visitNop() {
        this.add(Insn.nop());
    }

    @Override
    public void visitThrow() {
        this.add(Insn.athrow());
    }

    @Override
    public void visitMonitorInsn(int opcode) {
        this.add(Insn.monitor(opcode));
    }

    @Override
    public void visitArrayInsn(int opcode) {
        this.add(new ArrayInsn(opcode));
    }

    @Override
    public void visitArithmeticInsn(int opcode) {
        this.add(new ArithmeticInsn(opcode));
    }

    @Override
    public void visitConstantInsn(int opcode) {
        this.add(new ConstantInsn(opcode));
    }

    @Override
    public void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull Descriptor type) {
        this.add(new FieldInsn(opcode, owner, name, type));
    }

    @Override
    public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull Descriptor descriptor) {
        this.add(new MethodInsn(opcode, owner, name, descriptor));
    }

    @Override
    public void visitFlowInsn(int opcode, @Nonnull Label label) {
        this.add(new FlowInsn(opcode, label));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.add(new IntInsn(opcode, operand));
    }

    @Override
    public void visitIIncInsn(int var, int increment) {
        this.add(new IIncInsn(var, increment));
    }

    @Override
    public void visitInvokeDynamicInsn(@Nonnull String name, @Nonnull Descriptor descriptor, @Nonnull Handle bootstrapMethod, Constant ... bootstrapArgs) {
        this.add(new InvokeDynamicInsn(name, descriptor, bootstrapMethod, Arrays.asList(bootstrapArgs)));
    }

    @Override
    public void visitLdcInsn(@Nonnull Constant constant) {
        this.add(new LdcInsn(18, constant));
    }

    @Override
    public void visitLookupSwitchInsn(@Nonnull Label defaultLabel, int[] keys, Label ... labels) {
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        for (int key : keys) {
            keyList.add(key);
        }
        this.add(new LookupSwitchInsn(keyList, Arrays.asList(labels), defaultLabel));
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, @Nonnull Label defaultLabel, Label ... labels) {
        this.add(new TableSwitchInsn(min, max, Arrays.asList(labels), defaultLabel));
    }

    @Override
    public void visitMultiANewArrayInsn(@Nonnull String type, int dimensions) {
        this.add(new MultiANewArrayInsn(type, dimensions));
    }

    @Override
    public void visitStackInsn(int opcode) {
        this.add(new StackInsn(opcode));
    }

    @Override
    public void visitReturnInsn(int opcode) {
        this.add(new ReturnInsn(opcode));
    }

    @Override
    public void visitTypeInsn(int opcode, @Nonnull String type) {
        this.add(new TypeInsn(opcode, Descriptor.from((String)type)));
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.add(new VarInsn(opcode, var));
    }

    @Override
    public void visitLabel(@Nonnull Label label) {
        this.add(new LabelInsn(label));
    }

    @Override
    public void visitLocalVariable(int index, @Nonnull String name, @Nonnull Descriptor descriptor, @Nullable String signature, @Nonnull Label start, @Nonnull Label end) {
        Local local = new Local(index, name, descriptor, signature, start, end);
        this.locals.add(local);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocal) {
        this.maxStack = maxStack;
        this.maxLocals = maxLocal;
    }

    @Override
    public void visitExceptionHandler(@Nullable String type, @Nonnull Label start, @Nonnull Label end, @Nonnull Label handler) {
        this.handlers.add(new ExceptionHandler(type, start, end, handler));
    }

    public Code getCode() {
        return new Code(this.insns, this.locals, this.handlers, this.maxStack, this.maxLocals);
    }

    void add(Insn insn) {
        this.insns.add(insn);
    }
}

