/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.tree.visitor.DeclarationVisitor;
import software.coley.cafedude.tree.visitor.FieldVisitor;
import software.coley.cafedude.tree.visitor.MethodVisitor;
import software.coley.cafedude.tree.visitor.ModuleVisitor;
import software.coley.cafedude.tree.visitor.RecordComponentVisitor;

public interface ClassVisitor
extends DeclarationVisitor {
    default public ClassVisitor classDelegate() {
        return null;
    }

    @Override
    default public DeclarationVisitor declarationDelegate() {
        return this.classDelegate();
    }

    default public void visitClass(@Nonnull String name, int access, @Nullable String superName, String ... interfaces) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitClass(name, access, superName, interfaces);
        }
    }

    @Nullable
    default public MethodVisitor visitMethod(@Nonnull String name, int access, @Nonnull Descriptor descriptor) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            return delegate.visitMethod(name, access, descriptor);
        }
        return null;
    }

    @Nullable
    default public FieldVisitor visitField(@Nonnull String name, int access, @Nonnull Descriptor descriptor) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            return delegate.visitField(name, access, descriptor);
        }
        return null;
    }

    @Nullable
    default public RecordComponentVisitor visitRecordComponent(@Nonnull String name, @Nonnull Descriptor descriptor) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            return delegate.visitRecordComponent(name, descriptor);
        }
        return null;
    }

    @Nullable
    default public ModuleVisitor visitModule(@Nonnull String name, int access, @Nullable String version) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            return delegate.visitModule(name, access, version);
        }
        return null;
    }

    default public void visitOuterClass(@Nonnull String owner, @Nullable String name, @Nullable Descriptor descriptor) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitOuterClass(owner, name, descriptor);
        }
    }

    default public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int access) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitInnerClass(name, outerName, innerName, access);
        }
    }

    default public void visitSource(@Nullable String source, @Nullable byte[] debug) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitSource(source, debug);
        }
    }

    default public void visitNestHost(@Nonnull String nestHost) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitNestHost(nestHost);
        }
    }

    default public void visitNestMember(@Nonnull String nestMember) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitNestMember(nestMember);
        }
    }

    default public void visitPermittedSubclass(@Nonnull String permittedSubclass) {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitPermittedSubclass(permittedSubclass);
        }
    }

    default public void visitClassEnd() {
        ClassVisitor delegate = this.classDelegate();
        if (delegate != null) {
            delegate.visitClassEnd();
        }
    }
}

