/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.insn;

import java.util.List;
import javax.annotation.Nonnull;
import software.coley.cafedude.tree.Label;
import software.coley.cafedude.tree.insn.Insn;
import software.coley.cafedude.tree.insn.InsnKind;

public class LookupSwitchInsn
extends Insn {
    private int padding;
    private List<Integer> keys;
    private List<Label> labels;
    private Label defaultLabel;

    public LookupSwitchInsn(@Nonnull List<Integer> keys, @Nonnull List<Label> labels, @Nonnull Label defaultLabel) {
        super(InsnKind.LOOKUP_SWITCH, 171);
        this.keys = keys;
        this.labels = labels;
        this.defaultLabel = defaultLabel;
    }

    @Nonnull
    public List<Integer> getKeys() {
        return this.keys;
    }

    public void setKeys(@Nonnull List<Integer> keys) {
        this.keys = keys;
    }

    @Nonnull
    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(@Nonnull List<Label> labels) {
        this.labels = labels;
    }

    @Nonnull
    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(@Nonnull Label defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Override
    public int size() {
        return 1 + this.padding + 4 + 4 + this.keys.size() * 8;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lookupswitch([").append(this.padding).append("]) (\n");
        sb.append("  default: ").append(this.defaultLabel.getOffset()).append("\n");
        for (int i = 0; i < this.keys.size(); ++i) {
            sb.append("  ").append(this.keys.get(i)).append(" -> ").append(this.labels.get(i).getOffset()).append("\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

