/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.coley.cafedude.InvalidClassException;
import me.coley.cafedude.classfile.ClassFile;
import me.coley.cafedude.classfile.Field;
import me.coley.cafedude.classfile.Method;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.constant.ConstPoolEntry;
import me.coley.cafedude.classfile.constant.ConstRef;
import me.coley.cafedude.classfile.constant.CpClass;
import me.coley.cafedude.classfile.constant.CpDouble;
import me.coley.cafedude.classfile.constant.CpDynamic;
import me.coley.cafedude.classfile.constant.CpFloat;
import me.coley.cafedude.classfile.constant.CpInt;
import me.coley.cafedude.classfile.constant.CpInvokeDynamic;
import me.coley.cafedude.classfile.constant.CpLong;
import me.coley.cafedude.classfile.constant.CpMethodHandle;
import me.coley.cafedude.classfile.constant.CpMethodType;
import me.coley.cafedude.classfile.constant.CpModule;
import me.coley.cafedude.classfile.constant.CpNameType;
import me.coley.cafedude.classfile.constant.CpPackage;
import me.coley.cafedude.classfile.constant.CpString;
import me.coley.cafedude.classfile.constant.CpUtf8;
import me.coley.cafedude.io.AttributeWriter;

public class ClassFileWriter {
    private DataOutputStream out;
    private AttributeWriter attributeWriter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] write(ClassFile clazz) throws InvalidClassException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(baos);){
            this.out = out;
            this.attributeWriter = new AttributeWriter(clazz);
            out.writeInt(-889275714);
            out.writeShort(clazz.getVersionMinor());
            out.writeShort(clazz.getVersionMajor());
            out.writeShort(clazz.getPool().size() + 1);
            for (ConstPoolEntry entry : clazz.getPool()) {
                this.writeCpEntry(entry);
            }
            out.writeShort(clazz.getAccess());
            out.writeShort(clazz.getClassIndex());
            out.writeShort(clazz.getSuperIndex());
            out.writeShort(clazz.getInterfaceIndices().size());
            Object object = clazz.getInterfaceIndices().iterator();
            while (object.hasNext()) {
                int interfaceIdx = (Integer)object.next();
                out.writeShort(interfaceIdx);
            }
            out.writeShort(clazz.getFields().size());
            for (Field field : clazz.getFields()) {
                this.writeField(field);
            }
            out.writeShort(clazz.getMethods().size());
            for (Method method : clazz.getMethods()) {
                this.writeMethod(method);
            }
            out.writeShort(clazz.getAttributes().size());
            for (Attribute attribute : clazz.getAttributes()) {
                this.writeAttribute(attribute);
            }
            object = baos.toByteArray();
            return object;
        }
        catch (IOException ex) {
            throw new InvalidClassException(ex);
        }
    }

    private void writeCpEntry(ConstPoolEntry entry) throws IOException, InvalidClassException {
        int tag = entry.getTag();
        this.out.writeByte(tag);
        switch (tag) {
            case 1: {
                this.out.writeUTF(((CpUtf8)entry).getText());
                break;
            }
            case 3: {
                this.out.writeInt(((CpInt)entry).getValue());
                break;
            }
            case 4: {
                this.out.writeFloat(((CpFloat)entry).getValue());
                break;
            }
            case 5: {
                this.out.writeLong(((CpLong)entry).getValue());
                break;
            }
            case 6: {
                this.out.writeDouble(((CpDouble)entry).getValue());
                break;
            }
            case 8: {
                this.out.writeShort(((CpString)entry).getIndex());
                break;
            }
            case 7: {
                this.out.writeShort(((CpClass)entry).getIndex());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.out.writeShort(((ConstRef)entry).getClassIndex());
                this.out.writeShort(((ConstRef)entry).getNameTypeIndex());
                break;
            }
            case 12: {
                this.out.writeShort(((CpNameType)entry).getNameIndex());
                this.out.writeShort(((CpNameType)entry).getTypeIndex());
                break;
            }
            case 17: {
                this.out.writeShort(((CpDynamic)entry).getBsmIndex());
                this.out.writeShort(((CpDynamic)entry).getNameTypeIndex());
                break;
            }
            case 15: {
                this.out.writeByte(((CpMethodHandle)entry).getKind());
                this.out.writeShort(((CpMethodHandle)entry).getReferenceIndex());
                break;
            }
            case 16: {
                this.out.writeShort(((CpMethodType)entry).getIndex());
                break;
            }
            case 18: {
                this.out.writeShort(((CpInvokeDynamic)entry).getBsmIndex());
                this.out.writeShort(((CpInvokeDynamic)entry).getNameTypeIndex());
                break;
            }
            case 19: {
                this.out.writeShort(((CpModule)entry).getIndex());
                break;
            }
            case 20: {
                this.out.writeShort(((CpPackage)entry).getIndex());
                break;
            }
            default: {
                throw new InvalidClassException("Unknown constant-pool tag: " + tag);
            }
        }
    }

    private void writeAttribute(Attribute attribute) throws IOException, InvalidClassException {
        this.out.write(this.attributeWriter.writeAttribute(attribute));
    }

    private void writeField(Field field) throws IOException, InvalidClassException {
        this.out.writeShort(field.getAccess());
        this.out.writeShort(field.getNameIndex());
        this.out.writeShort(field.getTypeIndex());
        this.out.writeShort(field.getAttributes().size());
        for (Attribute attribute : field.getAttributes()) {
            this.writeAttribute(attribute);
        }
    }

    private void writeMethod(Method method) throws IOException, InvalidClassException {
        this.out.writeShort(method.getAccess());
        this.out.writeShort(method.getNameIndex());
        this.out.writeShort(method.getTypeIndex());
        this.out.writeShort(method.getAttributes().size());
        for (Attribute attribute : method.getAttributes()) {
            this.writeAttribute(attribute);
        }
    }
}

