/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.attribute;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.behavior.CpAccessor;

public class BootstrapMethodsAttribute
extends Attribute {
    private List<BootstrapMethod> bootstrapMethods;

    public BootstrapMethodsAttribute(int nameIndex, List<BootstrapMethod> bootstrapMethods) {
        super(nameIndex);
        this.bootstrapMethods = bootstrapMethods;
    }

    @Override
    public Set<Integer> cpAccesses() {
        Set<Integer> set = super.cpAccesses();
        for (BootstrapMethod bsm : this.bootstrapMethods) {
            set.addAll(bsm.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.bootstrapMethods.stream().mapToInt(BootstrapMethod::computeLength).sum();
    }

    public List<BootstrapMethod> getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    public void setBootstrapMethods(List<BootstrapMethod> bootstrapMethods) {
        this.bootstrapMethods = bootstrapMethods;
    }

    public static class BootstrapMethod
    implements CpAccessor {
        private int bsmMethodref;
        private List<Integer> args;

        public BootstrapMethod(int bsmMethodref, List<Integer> args) {
            this.bsmMethodref = bsmMethodref;
            this.args = args;
        }

        @Override
        public Set<Integer> cpAccesses() {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(this.getBsmMethodref());
            set.addAll(this.getArgs());
            return set;
        }

        public int getBsmMethodref() {
            return this.bsmMethodref;
        }

        public void setBsmMethodref(int bsmMethodref) {
            this.bsmMethodref = bsmMethodref;
        }

        public List<Integer> getArgs() {
            return this.args;
        }

        public void setArgs(List<Integer> args) {
            this.args = args;
        }

        public int computeLength() {
            return 4 + 2 * this.args.size();
        }
    }
}

