/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile.annotation;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import me.coley.cafedude.classfile.annotation.ElementValue;
import me.coley.cafedude.classfile.behavior.CpAccessor;

public class Annotation
implements CpAccessor {
    private final Map<Integer, ElementValue> values;
    private final int typeIndex;

    public Annotation(int typeIndex, Map<Integer, ElementValue> values) {
        this.typeIndex = typeIndex;
        this.values = values;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public Map<Integer, ElementValue> getValues() {
        return this.values;
    }

    @Override
    public Set<Integer> cpAccesses() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(this.getTypeIndex());
        for (ElementValue value : this.values.values()) {
            set.addAll(value.cpAccesses());
        }
        return set;
    }

    public int computeLength() {
        int length = 4;
        for (Map.Entry<Integer, ElementValue> entry : this.values.entrySet()) {
            length += 2;
            length += entry.getValue().computeLength();
        }
        return length;
    }
}

