/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.classfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import me.coley.cafedude.classfile.constant.ConstPoolEntry;
import me.coley.cafedude.classfile.constant.CpUtf8;

public class ConstPool
implements List<ConstPoolEntry> {
    private final List<ConstPoolEntry> backing = new ArrayList<ConstPoolEntry>();
    private final SortedSet<Integer> wideIndices = new TreeSet<Integer>();
    private final Map<Integer, Integer> indexToWides = new HashMap<Integer, Integer>();

    public void insertAfter(int index, ConstPoolEntry entry) {
        this.add(index, entry);
    }

    public void insertBefore(int index, ConstPoolEntry entry) {
        this.add(index - 1, entry);
    }

    public String getUtf(int index) {
        ConstPoolEntry entry = this.get(index);
        if (entry instanceof CpUtf8) {
            return ((CpUtf8)entry).getText();
        }
        throw new IllegalArgumentException("Index " + index + " not UTF8");
    }

    public boolean isIndexOfType(int index, Class<? extends ConstPoolEntry> type) {
        try {
            ConstPoolEntry entry = this.get(index);
            return type.isAssignableFrom(entry.getClass());
        }
        catch (Throwable t) {
            return false;
        }
    }

    private int internalToCp(int index) {
        int wideCount = this.indexToWides.computeIfAbsent(index, i -> this.wideIndices.headSet(i + 1).size());
        return 1 + index + wideCount;
    }

    private int cpToInternal(int index) {
        if (index == 0) {
            return index;
        }
        int internal = index - 1;
        while (this.internalToCp(internal - 1) >= index) {
            --internal;
        }
        return internal;
    }

    private void onClear() {
        this.wideIndices.clear();
    }

    private void onAdd(ConstPoolEntry constPoolEntry, int location) {
        int entrySize = constPoolEntry.isWide() ? 2 : 1;
        SortedSet<Integer> larger = this.wideIndices.tailSet(location);
        if (!larger.isEmpty()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>(larger);
            larger.clear();
            tmp.forEach(i -> this.addWideIndex(i + entrySize));
        }
        if (constPoolEntry.isWide()) {
            this.addWideIndex(location);
        }
    }

    private void onRemove(ConstPoolEntry constPoolEntry, int location) {
        SortedSet<Integer> larger;
        int entrySize;
        int n = entrySize = constPoolEntry.isWide() ? 2 : 1;
        if (constPoolEntry.isWide()) {
            this.wideIndices.remove(location);
        }
        if (!(larger = this.wideIndices.tailSet(location + 1)).isEmpty()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>(larger);
            larger.clear();
            tmp.forEach(i -> this.addWideIndex(i - entrySize));
        }
    }

    private void addWideIndex(int i) {
        this.wideIndices.add(i);
        this.indexToWides.clear();
    }

    @Override
    public int size() {
        if (this.backing.isEmpty()) {
            return 0;
        }
        return this.internalToCp(this.backing.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    public Iterator<ConstPoolEntry> iterator() {
        return this.backing.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.backing.toArray(new ConstPoolEntry[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backing.toArray();
    }

    @Override
    public boolean add(ConstPoolEntry constPoolEntry) {
        this.onAdd(constPoolEntry, this.backing.size());
        return this.backing.add(constPoolEntry);
    }

    @Override
    public void add(int index, ConstPoolEntry element) {
        this.onAdd(element, index);
        this.backing.add(this.cpToInternal(index), element);
    }

    @Override
    public ConstPoolEntry remove(int index) {
        ConstPoolEntry ret = this.backing.remove(this.cpToInternal(index));
        if (ret != null) {
            this.onRemove(ret, index);
        }
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof ConstPoolEntry) {
            ConstPoolEntry constPoolEntry = (ConstPoolEntry)o;
            this.onRemove(constPoolEntry, this.indexOf(constPoolEntry));
            return this.backing.remove(constPoolEntry);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backing.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ConstPoolEntry> c) {
        for (ConstPoolEntry constPoolEntry : c) {
            this.add(constPoolEntry);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends ConstPoolEntry> c) {
        for (ConstPoolEntry constPoolEntry : c) {
            this.add(index, constPoolEntry);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        for (ConstPoolEntry o : this) {
            if (c.contains(o)) continue;
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.onClear();
        this.backing.clear();
    }

    @Override
    public ConstPoolEntry get(int index) {
        return this.backing.get(this.cpToInternal(index));
    }

    @Override
    public ConstPoolEntry set(int index, ConstPoolEntry element) {
        ConstPoolEntry ret = this.remove(index);
        this.add(index, element);
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.internalToCp(this.backing.indexOf(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.internalToCp(this.backing.lastIndexOf(o));
    }

    @Override
    public ListIterator<ConstPoolEntry> listIterator() {
        return this.backing.listIterator();
    }

    @Override
    public ListIterator<ConstPoolEntry> listIterator(int index) {
        return this.backing.listIterator(this.cpToInternal(index));
    }

    @Override
    public List<ConstPoolEntry> subList(int fromIndex, int toIndex) {
        return this.backing.subList(this.cpToInternal(fromIndex), this.cpToInternal(toIndex));
    }
}

