/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.dexlib2.writer.pool.AnnotationPool;
import org.jf.dexlib2.writer.pool.AnnotationSetPool;
import org.jf.dexlib2.writer.pool.ClassPool;
import org.jf.dexlib2.writer.pool.FieldPool;
import org.jf.dexlib2.writer.pool.Markable;
import org.jf.dexlib2.writer.pool.MethodPool;
import org.jf.dexlib2.writer.pool.PoolClassDef;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.ProtoPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;
import org.jf.util.ExceptionWithContext;

public class DexPool
extends DexWriter<CharSequence, StringReference, CharSequence, TypeReference, MethodProtoReference, FieldReference, MethodReference, PoolClassDef, Annotation, Set<? extends Annotation>, TypeListPool.Key<? extends Collection<? extends CharSequence>>, Field, PoolMethod, EncodedValue, AnnotationElement, StringPool, TypePool, ProtoPool, FieldPool, MethodPool, ClassPool, TypeListPool, AnnotationPool, AnnotationSetPool> {
    private final Markable[] sections;

    public DexPool(Opcodes opcodes) {
        super(opcodes);
        this.sections = new Markable[]{(Markable)((Object)this.stringSection), (Markable)((Object)this.typeSection), (Markable)((Object)this.protoSection), (Markable)((Object)this.fieldSection), (Markable)((Object)this.methodSection), (Markable)((Object)this.classSection), (Markable)((Object)this.typeListSection), (Markable)((Object)this.annotationSection), (Markable)((Object)this.annotationSetSection)};
    }

    @Override
    protected DexWriter.SectionProvider getSectionProvider() {
        return new DexPoolSectionProvider();
    }

    public static void writeTo(DexDataStore dataStore, DexFile input) throws IOException {
        DexPool dexPool = new DexPool(input.getOpcodes());
        for (ClassDef classDef : input.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(dataStore);
    }

    public static void writeTo(String path, DexFile input) throws IOException {
        DexPool dexPool = new DexPool(input.getOpcodes());
        for (ClassDef classDef : input.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(new FileDataStore(new File(path)));
    }

    public void internClass(ClassDef classDef) {
        ((ClassPool)this.classSection).intern(classDef);
    }

    public void mark() {
        for (Markable section : this.sections) {
            section.mark();
        }
    }

    public void reset() {
        for (Markable section : this.sections) {
            section.reset();
        }
    }

    @Override
    protected void writeEncodedValue(DexWriter.InternalEncodedValueWriter writer, EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.getType(), annotationEncodedValue.getElements());
                break;
            }
            case 28: {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.getValue());
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)encodedValue).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)encodedValue).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)encodedValue).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)encodedValue).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)encodedValue).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)encodedValue).getValue());
                break;
            }
            case 23: {
                writer.writeString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                writer.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    void internEncodedValue(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                ((TypePool)this.typeSection).intern(annotationEncodedValue.getType());
                for (AnnotationElement annotationElement : annotationEncodedValue.getElements()) {
                    ((StringPool)this.stringSection).intern(annotationElement.getName());
                    this.internEncodedValue(annotationElement.getValue());
                }
                break;
            }
            case 28: {
                for (EncodedValue encodedValue2 : ((ArrayEncodedValue)encodedValue).getValue()) {
                    this.internEncodedValue(encodedValue2);
                }
                break;
            }
            case 23: {
                ((StringPool)this.stringSection).intern(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                ((TypePool)this.typeSection).intern(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                ((FieldPool)this.fieldSection).intern(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                ((FieldPool)this.fieldSection).intern(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                ((MethodPool)this.methodSection).intern(((MethodEncodedValue)encodedValue).getValue());
            }
        }
    }

    protected class DexPoolSectionProvider
    extends DexWriter.SectionProvider {
        protected DexPoolSectionProvider() {
        }

        public StringPool getStringSection() {
            return new StringPool(DexPool.this);
        }

        public TypePool getTypeSection() {
            return new TypePool(DexPool.this);
        }

        public ProtoPool getProtoSection() {
            return new ProtoPool(DexPool.this);
        }

        public FieldPool getFieldSection() {
            return new FieldPool(DexPool.this);
        }

        public MethodPool getMethodSection() {
            return new MethodPool(DexPool.this);
        }

        public ClassPool getClassSection() {
            return new ClassPool(DexPool.this);
        }

        public TypeListPool getTypeListSection() {
            return new TypeListPool(DexPool.this);
        }

        public AnnotationPool getAnnotationSection() {
            return new AnnotationPool(DexPool.this);
        }

        public AnnotationSetPool getAnnotationSetSection() {
            return new AnnotationSetPool(DexPool.this);
        }
    }
}

