/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.value;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableAnnotationEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableArrayEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableBooleanEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableByteEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableCharEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEnumEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFieldEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableLongEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableMethodEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableNullEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableShortEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableStringEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableTypeEncodedValue;
import org.jf.util.ExceptionWithContext;
import org.jf.util.ImmutableConverter;

public class ImmutableEncodedValueFactory {
    private static final ImmutableConverter<ImmutableEncodedValue, EncodedValue> CONVERTER = new ImmutableConverter<ImmutableEncodedValue, EncodedValue>(){

        @Override
        protected boolean isImmutable(EncodedValue item) {
            return item instanceof ImmutableEncodedValue;
        }

        @Override
        protected ImmutableEncodedValue makeImmutable(EncodedValue item) {
            return ImmutableEncodedValueFactory.of(item);
        }
    };

    public static ImmutableEncodedValue of(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 0: {
                return ImmutableByteEncodedValue.of((ByteEncodedValue)encodedValue);
            }
            case 2: {
                return ImmutableShortEncodedValue.of((ShortEncodedValue)encodedValue);
            }
            case 3: {
                return ImmutableCharEncodedValue.of((CharEncodedValue)encodedValue);
            }
            case 4: {
                return ImmutableIntEncodedValue.of((IntEncodedValue)encodedValue);
            }
            case 6: {
                return ImmutableLongEncodedValue.of((LongEncodedValue)encodedValue);
            }
            case 16: {
                return ImmutableFloatEncodedValue.of((FloatEncodedValue)encodedValue);
            }
            case 17: {
                return ImmutableDoubleEncodedValue.of((DoubleEncodedValue)encodedValue);
            }
            case 23: {
                return ImmutableStringEncodedValue.of((StringEncodedValue)encodedValue);
            }
            case 24: {
                return ImmutableTypeEncodedValue.of((TypeEncodedValue)encodedValue);
            }
            case 25: {
                return ImmutableFieldEncodedValue.of((FieldEncodedValue)encodedValue);
            }
            case 26: {
                return ImmutableMethodEncodedValue.of((MethodEncodedValue)encodedValue);
            }
            case 27: {
                return ImmutableEnumEncodedValue.of((EnumEncodedValue)encodedValue);
            }
            case 28: {
                return ImmutableArrayEncodedValue.of((ArrayEncodedValue)encodedValue);
            }
            case 29: {
                return ImmutableAnnotationEncodedValue.of((AnnotationEncodedValue)encodedValue);
            }
            case 30: {
                return ImmutableNullEncodedValue.INSTANCE;
            }
            case 31: {
                return ImmutableBooleanEncodedValue.of((BooleanEncodedValue)encodedValue);
            }
        }
        Preconditions.checkArgument((boolean)false);
        return null;
    }

    public static EncodedValue defaultValueForType(String type) {
        switch (type.charAt(0)) {
            case 'Z': {
                return ImmutableBooleanEncodedValue.FALSE_VALUE;
            }
            case 'B': {
                return new ImmutableByteEncodedValue(0);
            }
            case 'S': {
                return new ImmutableShortEncodedValue(0);
            }
            case 'C': {
                return new ImmutableCharEncodedValue('\u0000');
            }
            case 'I': {
                return new ImmutableIntEncodedValue(0);
            }
            case 'J': {
                return new ImmutableLongEncodedValue(0L);
            }
            case 'F': {
                return new ImmutableFloatEncodedValue(0.0f);
            }
            case 'D': {
                return new ImmutableDoubleEncodedValue(0.0);
            }
            case 'L': 
            case '[': {
                return ImmutableNullEncodedValue.INSTANCE;
            }
        }
        throw new ExceptionWithContext("Unrecognized type: %s", type);
    }

    public static ImmutableEncodedValue ofNullable(EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return ImmutableEncodedValueFactory.of(encodedValue);
    }

    public static ImmutableList<ImmutableEncodedValue> immutableListOf(Iterable<? extends EncodedValue> list) {
        return CONVERTER.toList(list);
    }
}

