/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;

public abstract class StaticInitialValueIterator {
    public static final StaticInitialValueIterator EMPTY = new StaticInitialValueIterator(){

        @Override
        public EncodedValue getNextOrNull() {
            return null;
        }

        @Override
        public void skipNext() {
        }

        @Override
        public int getReaderOffset() {
            return 0;
        }
    };

    public abstract EncodedValue getNextOrNull();

    public abstract void skipNext();

    public abstract int getReaderOffset();

    public static StaticInitialValueIterator newOrEmpty(DexBackedDexFile dexFile, int offset) {
        if (offset == 0) {
            return EMPTY;
        }
        return new StaticInitialValueIteratorImpl(dexFile, offset);
    }

    private static class StaticInitialValueIteratorImpl
    extends StaticInitialValueIterator {
        private final DexReader reader;
        private final int size;
        private int index = 0;

        public StaticInitialValueIteratorImpl(DexBackedDexFile dexFile, int offset) {
            this.reader = dexFile.readerAt(offset);
            this.size = this.reader.readSmallUleb128();
        }

        @Override
        public EncodedValue getNextOrNull() {
            if (this.index < this.size) {
                ++this.index;
                return DexBackedEncodedValue.readFrom(this.reader);
            }
            return null;
        }

        @Override
        public void skipNext() {
            if (this.index < this.size) {
                ++this.index;
                DexBackedEncodedValue.skipFrom(this.reader);
            }
        }

        @Override
        public int getReaderOffset() {
            return this.reader.getOffset();
        }
    }
}

