/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class TypeIdItem {
    public static final int ITEM_SIZE = 4;

    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "type_id_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int stringIndex = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, StringIdItem.getReferenceAnnotation(this.dexFile, stringIndex), new Object[0]);
            }
        };
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int typeIndex) {
        try {
            String typeString = dexFile.getType(typeIndex);
            return String.format("type_id_item[%d]: %s", typeIndex, typeString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("type_id_item[%d]", typeIndex);
        }
    }

    public static String getOptionalReferenceAnnotation(DexBackedDexFile dexFile, int typeIndex) {
        if (typeIndex == -1) {
            return "type_id_item[NO_INDEX]";
        }
        return TypeIdItem.getReferenceAnnotation(dexFile, typeIndex);
    }

    public static String[] getTypes(RawDexFile dexFile) {
        MapItem mapItem = dexFile.getMapItemForSection(2);
        if (mapItem == null) {
            return new String[0];
        }
        int typeCount = mapItem.getItemCount();
        String[] ret = new String[typeCount];
        for (int i = 0; i < typeCount; ++i) {
            ret[i] = dexFile.getType(i);
        }
        return ret;
    }
}

