/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import java.util.Set;
import org.jf.dexlib2.base.reference.BaseFieldReference;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import org.jf.dexlib2.dexbacked.util.StaticInitialValueIterator;
import org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;

public class DexBackedField
extends BaseFieldReference
implements Field {
    public final DexBackedDexFile dexFile;
    public final ClassDef classDef;
    public final int accessFlags;
    public final EncodedValue initialValue;
    public final int annotationSetOffset;
    public final int fieldIndex;
    private final int startOffset;
    private final int initialValueOffset;
    private int fieldIdItemOffset;

    public DexBackedField(DexReader reader, DexBackedClassDef classDef, int previousFieldIndex, StaticInitialValueIterator staticInitialValueIterator, AnnotationsDirectory.AnnotationIterator annotationIterator) {
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = staticInitialValueIterator.getReaderOffset();
        this.initialValue = staticInitialValueIterator.getNextOrNull();
    }

    public DexBackedField(DexReader reader, DexBackedClassDef classDef, int previousFieldIndex, AnnotationsDirectory.AnnotationIterator annotationIterator) {
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = 0;
        this.initialValue = null;
    }

    @Override
    public String getName() {
        return this.dexFile.getString(this.dexFile.readSmallUint(this.getFieldIdItemOffset() + 4));
    }

    @Override
    public String getType() {
        return this.dexFile.getType(this.dexFile.readUshort(this.getFieldIdItemOffset() + 2));
    }

    @Override
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.annotationSetOffset);
    }

    public static void skipFields(DexReader reader, int count) {
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }

    private int getFieldIdItemOffset() {
        if (this.fieldIdItemOffset == 0) {
            this.fieldIdItemOffset = this.dexFile.getFieldIdItemOffset(this.fieldIndex);
        }
        return this.fieldIdItemOffset;
    }

    public int getSize() {
        int size = 0;
        DexReader reader = this.dexFile.readerAt(this.startOffset);
        reader.readLargeUleb128();
        reader.readSmallUleb128();
        size += reader.getOffset() - this.startOffset;
        Set<? extends DexBackedAnnotation> annotations = this.getAnnotations();
        if (!annotations.isEmpty()) {
            size += 8;
        }
        if (this.initialValueOffset > 0) {
            reader.setOffset(this.initialValueOffset);
            if (this.initialValue != null) {
                DexBackedEncodedValue.skipFrom(reader);
                size += reader.getOffset() - this.initialValueOffset;
            }
        }
        DexBackedFieldReference fieldRef = new DexBackedFieldReference(this.dexFile, this.fieldIndex);
        return size += fieldRef.getSize();
    }
}

