/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.base.BaseTryBlock;
import org.jf.dexlib2.builder.BuilderExceptionHandler;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.iface.reference.TypeReference;

public class BuilderTryBlock
extends BaseTryBlock<BuilderExceptionHandler> {
    public final BuilderExceptionHandler exceptionHandler;
    public final Label start;
    public final Label end;

    public BuilderTryBlock(Label start, Label end, String exceptionType, Label handler) {
        this.start = start;
        this.end = end;
        this.exceptionHandler = BuilderExceptionHandler.newExceptionHandler(exceptionType, handler);
    }

    public BuilderTryBlock(Label start, Label end, TypeReference exceptionType, Label handler) {
        this.start = start;
        this.end = end;
        this.exceptionHandler = BuilderExceptionHandler.newExceptionHandler(exceptionType, handler);
    }

    public BuilderTryBlock(Label start, Label end, Label handler) {
        this.start = start;
        this.end = end;
        this.exceptionHandler = BuilderExceptionHandler.newExceptionHandler(handler);
    }

    @Override
    public int getStartCodeAddress() {
        return this.start.getCodeAddress();
    }

    @Override
    public int getCodeUnitCount() {
        return this.end.getCodeAddress() - this.start.getCodeAddress();
    }

    @Override
    public List<? extends BuilderExceptionHandler> getExceptionHandlers() {
        return ImmutableList.of((Object)this.exceptionHandler);
    }
}

