/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis.reflection;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.analysis.reflection.ReflectionConstructor;
import org.jf.dexlib2.analysis.reflection.ReflectionField;
import org.jf.dexlib2.analysis.reflection.ReflectionMethod;
import org.jf.dexlib2.analysis.reflection.util.ReflectionUtils;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;

public class ReflectionClassDef
extends BaseTypeReference
implements ClassDef {
    private final Class cls;
    private static final int DIRECT_MODIFIERS = 10;

    public ReflectionClassDef(Class cls) {
        this.cls = cls;
    }

    @Override
    public int getAccessFlags() {
        return this.cls.getModifiers();
    }

    @Override
    public String getSuperclass() {
        if (Modifier.isInterface(this.cls.getModifiers())) {
            return "Ljava/lang/Object;";
        }
        Class superClass = this.cls.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return ReflectionUtils.javaToDexName(superClass.getName());
    }

    @Override
    public List<String> getInterfaces() {
        return ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])this.cls.getInterfaces()), (Function)new Function<Class, String>(){

            public String apply(Class input) {
                if (input == null) {
                    return null;
                }
                return ReflectionUtils.javaToDexName(input.getName());
            }
        }));
    }

    @Override
    public String getSourceFile() {
        return null;
    }

    @Override
    public Set<? extends Annotation> getAnnotations() {
        return ImmutableSet.of();
    }

    @Override
    public Iterable<? extends org.jf.dexlib2.iface.Field> getStaticFields() {
        return new Iterable<org.jf.dexlib2.iface.Field>(){

            @Override
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                UnmodifiableIterator staticFields = Iterators.filter((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredFields()), (Predicate)new Predicate<Field>(){

                    public boolean apply(Field input) {
                        return input != null && Modifier.isStatic(input.getModifiers());
                    }
                });
                return Iterators.transform((Iterator)staticFields, (Function)new Function<Field, org.jf.dexlib2.iface.Field>(){

                    public org.jf.dexlib2.iface.Field apply(Field input) {
                        return new ReflectionField(input);
                    }
                });
            }
        };
    }

    @Override
    public Iterable<? extends org.jf.dexlib2.iface.Field> getInstanceFields() {
        return new Iterable<org.jf.dexlib2.iface.Field>(){

            @Override
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                UnmodifiableIterator staticFields = Iterators.filter((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredFields()), (Predicate)new Predicate<Field>(){

                    public boolean apply(Field input) {
                        return input != null && !Modifier.isStatic(input.getModifiers());
                    }
                });
                return Iterators.transform((Iterator)staticFields, (Function)new Function<Field, org.jf.dexlib2.iface.Field>(){

                    public org.jf.dexlib2.iface.Field apply(Field input) {
                        return new ReflectionField(input);
                    }
                });
            }
        };
    }

    public Set<? extends org.jf.dexlib2.iface.Field> getFields() {
        return new AbstractSet<org.jf.dexlib2.iface.Field>(){

            @Override
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                return Iterators.transform((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredFields()), (Function)new Function<Field, org.jf.dexlib2.iface.Field>(){

                    public org.jf.dexlib2.iface.Field apply(Field input) {
                        return new ReflectionField(input);
                    }
                });
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredFields().length;
            }
        };
    }

    @Override
    public Iterable<? extends Method> getDirectMethods() {
        return new Iterable<Method>(){

            @Override
            public Iterator<Method> iterator() {
                Iterator constructorIterator = Iterators.transform((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredConstructors()), (Function)new Function<Constructor, Method>(){

                    public Method apply(Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                UnmodifiableIterator directMethods = Iterators.filter((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredMethods()), (Predicate)new Predicate<java.lang.reflect.Method>(){

                    public boolean apply(java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) != 0;
                    }
                });
                Iterator methodIterator = Iterators.transform((Iterator)directMethods, (Function)new Function<java.lang.reflect.Method, Method>(){

                    public Method apply(java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                return Iterators.concat((Iterator)constructorIterator, (Iterator)methodIterator);
            }
        };
    }

    @Override
    public Iterable<? extends Method> getVirtualMethods() {
        return new Iterable<Method>(){

            @Override
            public Iterator<Method> iterator() {
                UnmodifiableIterator directMethods = Iterators.filter((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredMethods()), (Predicate)new Predicate<java.lang.reflect.Method>(){

                    public boolean apply(java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) == 0;
                    }
                });
                return Iterators.transform((Iterator)directMethods, (Function)new Function<java.lang.reflect.Method, Method>(){

                    public Method apply(java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
            }
        };
    }

    public Set<? extends Method> getMethods() {
        return new AbstractSet<Method>(){

            @Override
            public Iterator<Method> iterator() {
                Iterator constructorIterator = Iterators.transform((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredConstructors()), (Function)new Function<Constructor, Method>(){

                    public Method apply(Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                Iterator methodIterator = Iterators.transform((Iterator)Iterators.forArray((Object[])ReflectionClassDef.this.cls.getDeclaredMethods()), (Function)new Function<java.lang.reflect.Method, Method>(){

                    public Method apply(java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                return Iterators.concat((Iterator)constructorIterator, (Iterator)methodIterator);
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredMethods().length + ReflectionClassDef.this.cls.getDeclaredConstructors().length;
            }
        };
    }

    @Override
    public String getType() {
        return ReflectionUtils.javaToDexName(this.cls.getName());
    }
}

