/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.android.dex.util.FileUtils;
import com.googlecode.d2j.dex.Dex2jar;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.tools.BaseCmd;
import com.googlecode.dex2jar.tools.Dex2jarCmd;
import com.googlecode.dex2jar.tools.Jar2Dex;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jf.DexLib2Utils;
import top.niunaijun.obfuscator.ObfuscatorConfiguration;

@BaseCmd.Syntax(cmd="d2j-black-obfuscator", syntax="[options] <file0> [file1 ... fileN]", desc="convert dex to jar")
public class BlackObfuscatorCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="d", longOpt="depth", description="Obfuscator Depth")
    private int depth;
    @BaseCmd.Opt(opt="i", longOpt="input", description="Origin Dex File")
    private Path input;
    @BaseCmd.Opt(opt="o", longOpt="output", description="Target Dex Path")
    private Path output;
    @BaseCmd.Opt(opt="p", longOpt="package", description="Package Name,Simple Filter")
    private String pkg;
    @BaseCmd.Opt(opt="a", longOpt="allow", description="Allow List File Path")
    private Path allowList;
    private final List<String> whileList = new ArrayList<String>();
    private final List<String> blackList = new ArrayList<String>();

    public static void main(String ... args) {
        new BlackObfuscatorCmd().doMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommandLine() throws Exception {
        File obfDex;
        File splitDex;
        File tempJar;
        block10: {
            block9: {
                block8: {
                    tempJar = null;
                    splitDex = null;
                    obfDex = null;
                    if (this.remainingArgs.length != 0) break block8;
                    this.usage();
                    this.deleteFile(tempJar, splitDex, obfDex);
                    return;
                }
                if (this.input != null) break block9;
                this.usage();
                this.deleteFile(tempJar, splitDex, obfDex);
                return;
            }
            this.checkFilter();
            this.checkInput();
            this.input = this.input.toAbsolutePath();
            if (this.output == null) {
                this.output = Paths.get("./", "obf.dex");
            }
            this.output = this.output.toAbsolutePath();
            tempJar = Paths.get(this.output.getParent().toString(), System.currentTimeMillis() + "obf.jar").toFile();
            splitDex = Paths.get(this.output.getParent().toString(), System.currentTimeMillis() + "split.dex").toFile();
            obfDex = Paths.get(this.output.getParent().toString(), System.currentTimeMillis() + "obf.dex").toFile();
            File finalTempJar = tempJar;
            File finalSplitDex = splitDex;
            File finalObfDex = obfDex;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.deleteFile(finalTempJar, finalSplitDex, finalObfDex)));
            long l = DexLib2Utils.splitDex((File)this.input.toFile(), (File)splitDex, this.whileList, this.blackList);
            if (l > 0L) break block10;
            System.out.println("No classes found");
            this.deleteFile(tempJar, splitDex, obfDex);
            return;
        }
        try {
            new Dex2jarCmd(new ObfuscatorConfiguration(){

                public int getObfDepth() {
                    return BlackObfuscatorCmd.this.depth;
                }
            }).doMain(new String[]{"-f", splitDex.getPath(), "-o", tempJar.toString()});
            new Jar2Dex().doMain(new String[]{"-f", "-o", obfDex.toString(), tempJar.toString()});
            DexLib2Utils.mergerAndCoverDexFile((File)this.input.toFile(), (File)obfDex, (File)this.output.toFile());
            System.out.println("BlackObfuscator Out =====> " + this.output.toString());
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                this.deleteFile(tempJar, splitDex, obfDex);
                throw throwable;
            }
            this.deleteFile(tempJar, splitDex, obfDex);
        }
        this.deleteFile(tempJar, splitDex, obfDex);
    }

    protected String getVersionString() {
        return "BlackObfuscatorCmd-" + DexFileReader.class.getPackage().getImplementationVersion() + ", translator-" + Dex2jar.class.getPackage().getImplementationVersion() + ", ir-" + ET.class.getPackage().getImplementationVersion();
    }

    private void checkFilter() throws IOException {
        int level = 0;
        if (this.pkg != null) {
            this.whileList.add(this.pkg);
            ++level;
        }
        if (this.allowList != null) {
            this.dealAllowList();
            ++level;
        }
        if (level > 1) {
            throw new IOException("-p and -a Can't be at the same time");
        }
    }

    private void checkInput() throws IOException {
        if (!this.input.toFile().exists()) {
            throw new IOException("Origin Dex not exists");
        }
    }

    private void dealAllowList() {
        if (!this.allowList.toFile().exists()) {
            System.out.println("Allow Rule File Not Exists");
            return;
        }
        String allowRule = new String(FileUtils.readFile((File)this.allowList.toFile()));
        for (String rule : allowRule.split("\n")) {
            if ((rule = rule.trim()).startsWith("#") || rule.isEmpty()) continue;
            if (rule.startsWith("!")) {
                this.blackList.add(rule.replaceFirst("!", ""));
                continue;
            }
            this.whileList.add(rule);
        }
    }

    private void deleteFile(File ... files) {
        for (File file : files) {
            if (file == null) continue;
            file.delete();
        }
    }
}

