/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.obfuscator.chain;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import top.niunaijun.obfuscator.ObfuscatorConfiguration;
import top.niunaijun.obfuscator.RebuildIfResult;
import top.niunaijun.obfuscator.chain.base.BaseObfuscatorChain;

public class SubObfuscator
extends BaseObfuscatorChain {
    public SubObfuscator(ObfuscatorConfiguration obfuscatorConfiguration) {
        super(obfuscatorConfiguration);
    }

    @Override
    public boolean canHandle(IrMethod ir, Stmt stmt) {
        return stmt.st == Stmt.ST.ASSIGN || stmt.st == Stmt.ST.VOID_INVOKE;
    }

    @Override
    public RebuildIfResult reBuild0(IrMethod ir, Stmt stmt, List<Stmt> origStmts) {
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        RebuildIfResult rebuildIfResult = new RebuildIfResult(newStmts);
        switch (stmt.st) {
            case ASSIGN: {
                this.reBuildAssign(ir, stmt, origStmts, newStmts);
                break;
            }
            case VOID_INVOKE: {
                this.reBuildVoidInvoke(ir, stmt, origStmts, newStmts);
                break;
            }
            default: {
                newStmts.add(stmt);
            }
        }
        return rebuildIfResult;
    }

    @Override
    public void reBuildEnd(IrMethod ir, List<Stmt> newStmts, List<Stmt> origStmts) {
    }

    private void reBuildAssign(IrMethod ir, Stmt stmt, List<Stmt> origStmts, List<Stmt> newStmts) {
        Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
        Value v1 = e2.op1;
        Value v2 = e2.op2;
        switch (v1.vt) {
            case LOCAL: {
                if (v1.valueType.charAt(0) != 'I') break;
                if (v2.vt == Value.VT.ADD) {
                    if (v2.getOp2().vt != Value.VT.CONSTANT) break;
                    int increment = (Integer)((Constant)v2.getOp2()).value;
                    v2.vt = Value.VT.SUB;
                    v2.setOp2((Value)Exprs.nInt((int)(-increment)));
                    break;
                }
                if (v2.vt == Value.VT.SUB) {
                    if (v2.getOp2().vt != Value.VT.CONSTANT) break;
                    int increment = (Integer)((Constant)v2.getOp2()).value;
                    v2.vt = Value.VT.ADD;
                    v2.setOp2((Value)Exprs.nInt((int)(-increment)));
                    break;
                }
                if (v2.vt != Value.VT.XOR) break;
                Local local = this.newLocal("xor", "I");
                newStmts.add((Stmt)Stmts.nAssign((Value)local, (Value)Exprs.nInt((int)new Random().nextInt(1000))));
                Local left = this.newLocal("xor_left", "I");
                newStmts.add((Stmt)Stmts.nAssign((Value)left, (Value)Exprs.nXor((Value)v2.getOp1(), (Value)local, (String)"I")));
                v2.setOp1((Value)left);
                Local right = this.newLocal("xor_right", "I");
                newStmts.add((Stmt)Stmts.nAssign((Value)right, (Value)Exprs.nXor((Value)v2.getOp2(), (Value)local, (String)"I")));
                v2.setOp2((Value)right);
            }
        }
        newStmts.add(stmt);
    }

    private void reBuildVoidInvoke(IrMethod ir, Stmt stmt, List<Stmt> origStmts, List<Stmt> newStmts) {
        Stmt.E1Stmt e1 = (Stmt.E1Stmt)stmt;
        newStmts.add(stmt);
    }
}

