/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.obfuscator.chain;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.IfStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import top.niunaijun.obfuscator.LBlock;
import top.niunaijun.obfuscator.ObfuscatorConfiguration;
import top.niunaijun.obfuscator.RebuildIfResult;
import top.niunaijun.obfuscator.chain.base.BaseObfuscatorChain;

public class IfObfuscator
extends BaseObfuscatorChain {
    private static final int MAPPING_INDEX = 0;
    private static final int MAPPING_GOTO = 1;
    private static final int MAPPING_ELSE = 2;
    private static final int MAPPING_ENTER = 3;
    private static final int MAPPING_NEXT = 4;
    private static final int MAPPING_FAKE = 5;

    public IfObfuscator(ObfuscatorConfiguration obfuscatorConfiguration) {
        super(obfuscatorConfiguration);
    }

    @Override
    public boolean canHandle(IrMethod ir, Stmt stmt) {
        return stmt.st == Stmt.ST.IF;
    }

    @Override
    public RebuildIfResult reBuild0(IrMethod ir, Stmt stmt, List<Stmt> origStmts) {
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        IfStmt ifStmt = (IfStmt)stmt;
        LBlock targetBlock = this.getIfTargetStmts(ifStmt);
        LBlock elseBlock = this.generateLBlock();
        Map<Integer, String> mapping = this.generateObfLocalMapping(this.depth);
        Local obfIndexFinal = this.newLocal("obf_index_final", "I");
        Local obfIndex = this.newLocal("obf_index", "I");
        Local obfStrHash = this.newLocal("obf_hash", "I");
        Local obfStr = this.newLocal("obf_str", "Ljava/lang/String;");
        LBlock startBlock = this.generateLBlock();
        int obfIndexI = mapping.get(0).hashCode();
        newStmts.add((Stmt)startBlock.getLabelStmt());
        newStmts.add((Stmt)Stmts.nAssign((Value)obfIndexFinal, (Value)Exprs.nInt((int)obfIndexI)));
        newStmts.add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString((String)mapping.get(3))));
        LabelStmt whileBegin = this.createWhile(newStmts);
        newStmts.add((Stmt)Stmts.nAssign((Value)obfStrHash, (Value)this.hashInvoke(obfStr)));
        newStmts.add((Stmt)Stmts.nAssign((Value)obfIndex, (Value)Exprs.nXor((Value)obfIndexFinal, (Value)obfStrHash, (String)"I")));
        LBlock fake = this.generateLBlock();
        fake.getStmts().add((Stmt)Stmts.nAssign((Value)obfIndex, (Value)obfIndex));
        fake.getStmts().add((Stmt)Stmts.nGoto((LabelStmt)whileBegin));
        LBlock gotoJumpBlock = this.generateLBlock();
        gotoJumpBlock.getStmts().add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString((String)mapping.get(1))));
        gotoJumpBlock.getStmts().add((Stmt)Stmts.nGoto((LabelStmt)whileBegin));
        LBlock enterBlock = this.generateLBlock();
        ifStmt.target = gotoJumpBlock.getLabelStmt();
        enterBlock.getStmts().add((Stmt)ifStmt);
        enterBlock.getStmts().add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString((String)mapping.get(2))));
        enterBlock.getStmts().add((Stmt)Stmts.nGoto((LabelStmt)whileBegin));
        elseBlock.getStmts().add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString((String)mapping.get(4))));
        elseBlock.getStmts().add((Stmt)Stmts.nGoto((LabelStmt)whileBegin));
        LBlock nextBlock = this.generateLBlock();
        LBlock defaultTarget = this.generateLBlock();
        LinkedHashMap<Integer, LabelStmt> switchBlock = new LinkedHashMap<Integer, LabelStmt>();
        LinkedHashMap newSwitchBlock = new LinkedHashMap();
        switchBlock.put(mapping.get(1).hashCode() ^ obfIndexI, targetBlock.getLabelStmt());
        switchBlock.put(mapping.get(2).hashCode() ^ obfIndexI, elseBlock.getLabelStmt());
        switchBlock.put(mapping.get(3).hashCode() ^ obfIndexI, enterBlock.getLabelStmt());
        switchBlock.put(mapping.get(4).hashCode() ^ obfIndexI, nextBlock.getLabelStmt());
        switchBlock.put(mapping.get(5).hashCode() ^ obfIndexI, fake.getLabelStmt());
        ArrayList sortList = new ArrayList(switchBlock.keySet());
        Collections.shuffle(sortList);
        for (Integer integer2 : sortList) {
            newSwitchBlock.put(integer2, switchBlock.get(integer2));
        }
        LookupSwitchStmt lookupSwitchStmt = Stmts.nLookupSwitch((Value)obfIndex, (int[])newSwitchBlock.keySet().stream().mapToInt(integer -> integer).toArray(), (LabelStmt[])newSwitchBlock.values().toArray(new LabelStmt[0]), (LabelStmt)defaultTarget.getLabelStmt());
        newStmts.add((Stmt)lookupSwitchStmt);
        newStmts.add((Stmt)defaultTarget.getLabelStmt());
        newStmts.addAll(defaultTarget.getStmts());
        newStmts.add((Stmt)fake.getLabelStmt());
        newStmts.addAll(fake.getStmts());
        newStmts.add((Stmt)gotoJumpBlock.getLabelStmt());
        newStmts.addAll(gotoJumpBlock.getStmts());
        newStmts.add((Stmt)enterBlock.getLabelStmt());
        newStmts.addAll(enterBlock.getStmts());
        newStmts.add((Stmt)elseBlock.getLabelStmt());
        newStmts.addAll(elseBlock.getStmts());
        newStmts.add((Stmt)nextBlock.getLabelStmt());
        newStmts.addAll(nextBlock.getStmts());
        LabelStmt ifStmtLabel = this.findIfStmtLabel(ifStmt, origStmts);
        if (ifStmtLabel != null) {
            for (Trap trap : ir.traps) {
                if (trap.end != ifStmtLabel) continue;
                trap.end = elseBlock.getLabelStmt();
            }
        }
        return new RebuildIfResult(newStmts);
    }

    @Override
    public void reBuildEnd(IrMethod ir, List<Stmt> newStmts, List<Stmt> origStmts) {
    }

    private LBlock generateLBlock() {
        return new LBlock();
    }

    private InvokeExpr hashInvoke(Local strLocal) {
        return Exprs.nInvokeVirtual((Value[])new Value[]{strLocal}, (String)"Ljava/lang/String;", (String)"hashCode", (String[])new String[0], (String)"I");
    }

    private Map<Integer, String> generateObfLocalMapping(int depth) {
        HashMap<Integer, String> mapping = new HashMap<Integer, String>();
        mapping.put(0, this.randomString(depth));
        mapping.put(1, this.randomString(depth));
        mapping.put(2, this.randomString(depth));
        mapping.put(3, this.randomString(depth));
        mapping.put(4, this.randomString(depth));
        mapping.put(5, this.randomString(depth));
        HashSet<String> set = new HashSet<String>();
        for (String value : mapping.values()) {
            if (set.contains(value)) {
                return this.generateObfLocalMapping(depth);
            }
            set.add(value);
        }
        return mapping;
    }

    private LabelStmt createWhile(List<Stmt> newStmts) {
        LBlock block = new LBlock();
        newStmts.add((Stmt)block.getLabelStmt());
        return block.getLabelStmt();
    }

    private LBlock getIfTargetStmts(IfStmt ifStmt) {
        LBlock block = new LBlock();
        block.setLabelStmt(ifStmt.target);
        return block;
    }

    private LabelStmt findIfStmtLabel(IfStmt ifStmt, List<Stmt> orig) {
        boolean found = false;
        for (int i = orig.size() - 1; i >= 0; --i) {
            Stmt stmt = orig.get(i);
            if (stmt == ifStmt) {
                found = true;
                continue;
            }
            if (!found || stmt.st != Stmt.ST.LABEL) continue;
            return (LabelStmt)stmt;
        }
        return null;
    }
}

