/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.obfuscator.chain;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import top.niunaijun.obfuscator.LBlock;
import top.niunaijun.obfuscator.ObfuscatorConfiguration;
import top.niunaijun.obfuscator.RebuildIfResult;
import top.niunaijun.obfuscator.chain.base.BaseObfuscatorChain;

public class FlowObfuscator
extends BaseObfuscatorChain {
    public FlowObfuscator(ObfuscatorConfiguration obfuscatorConfiguration) {
        super(obfuscatorConfiguration);
    }

    @Override
    public boolean canDepth() {
        return false;
    }

    @Override
    public boolean canHandle(IrMethod ir, Stmt stmt) {
        return true;
    }

    @Override
    public RebuildIfResult reBuild0(IrMethod ir, Stmt stmt, List<Stmt> origStmts) {
        return null;
    }

    @Override
    public void reBuildEnd(IrMethod ir, List<Stmt> newStmts, List<Stmt> origStmts) {
        if (ir.traps.size() > 0 || ir.name.equals("<init>")) {
            newStmts.addAll(origStmts);
            return;
        }
        ArrayList<Stmt> orig = new ArrayList<Stmt>(origStmts);
        boolean existCallSuper = false;
        ArrayList<Stmt> tmp = new ArrayList<Stmt>();
        int max = 3;
        for (int i = 0; i < max && i <= orig.size() - 1; ++i) {
            Stmt stmt = (Stmt)orig.get(i);
            if (stmt.st == Stmt.ST.IDENTITY) {
                ++max;
            }
            tmp.add(stmt);
            existCallSuper = this.isCallSuper(stmt);
            if (existCallSuper) break;
        }
        if (!existCallSuper) {
            orig = new ArrayList<Stmt>(origStmts);
        } else {
            newStmts.addAll(tmp);
            for (Stmt stmt : tmp) {
                orig.remove(stmt);
            }
        }
        for (Stmt origStmt : orig) {
            if (origStmt.st != Stmt.ST.ASSIGN && origStmt.st != Stmt.ST.IDENTITY) continue;
            Stmt.E2Stmt e2Stmt = (Stmt.E2Stmt)origStmt;
            Value op1 = e2Stmt.getOp1();
            if (op1.vt != Value.VT.LOCAL) continue;
            Local local1 = (Local)op1;
            if (e2Stmt.getOp2().vt == Value.VT.THIS_REF || e2Stmt.getOp2().vt == Value.VT.PARAMETER_REF) continue;
            local1._ls_index = this.newLocal((String)"new_local", (String)e2Stmt.getOp2().valueType)._ls_index;
            newStmts.add((Stmt)Stmts.nAssign((Value)local1, (Value)this.getNullValue(e2Stmt.getOp2())));
        }
        Local obfIndexFinal = this.newLocal("obf_index_final", "I");
        Local obfIndex = this.newLocal("obf_index", "I");
        Local obfStrHash = this.newLocal("obf_hash", "I");
        Local obfStr = this.newLocal("obf_str", "Ljava/lang/String;");
        LBlock whileBlock = this.generateLBlock();
        List<LBlock> origBlocks = this.getAllBlock(ir.traps, orig);
        HashMap<LabelStmt, LBlock> origBlockMaps = new HashMap<LabelStmt, LBlock>();
        for (LBlock lBlock : origBlocks) {
            origBlockMaps.put(lBlock.getLabelStmt(), lBlock);
        }
        HashSet<LabelStmt> exceptionBlock = new HashSet<LabelStmt>();
        for (LBlock origBlock : origBlocks) {
            if (origBlock.getTrap() == null) continue;
            exceptionBlock.addAll(Arrays.asList(origBlock.getTrap().handlers));
        }
        LinkedList linkedList = new LinkedList();
        LBlock lastBlock = null;
        for (LBlock lBlock : origBlocks) {
            String label = null;
            ArrayList<LBlock> tmpBlocks = new ArrayList<LBlock>();
            if (exceptionBlock.contains(lBlock.getLabelStmt())) continue;
            for (Stmt stmt : lBlock.getStmts()) {
                if (this.isCallSuper(stmt) && lastBlock != null) {
                    lastBlock.getStmts().add(stmt);
                    continue;
                }
                LBlock newBlock = new LBlock();
                newBlock.getStmts().add(stmt);
                newBlock.setKey(this.randomString(this.depth));
                newBlock.setTrap(lBlock.getTrap());
                tmpBlocks.add(newBlock);
                if (label == null) {
                    label = newBlock.getKey();
                }
                if (lastBlock != null) {
                    lastBlock.setNextKey(newBlock.getKey());
                }
                lastBlock = newBlock;
            }
            linkedList.addAll(tmpBlocks);
            if (label == null) continue;
            lBlock.getStmts().clear();
            lBlock.getStmts().add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString(label)));
            lBlock.getStmts().add((Stmt)Stmts.nGoto((LabelStmt)whileBlock.getLabelStmt()));
        }
        LBlock defaultTarget = this.generateLBlock();
        defaultTarget.getStmts().add((Stmt)Stmts.nGoto((LabelStmt)whileBlock.getLabelStmt()));
        LBlock enter = (LBlock)linkedList.get(0);
        int obfIndexI = this.randomString(this.depth).hashCode();
        newStmts.add((Stmt)Stmts.nAssign((Value)obfIndexFinal, (Value)Exprs.nInt((int)obfIndexI)));
        newStmts.add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString((String)enter.getKey())));
        newStmts.add((Stmt)whileBlock.getLabelStmt());
        newStmts.add((Stmt)Stmts.nAssign((Value)obfStrHash, (Value)this.hashInvoke(obfStr)));
        newStmts.add((Stmt)Stmts.nAssign((Value)obfIndex, (Value)Exprs.nXor((Value)obfIndexFinal, (Value)obfStrHash, (String)"I")));
        LinkedHashMap<Integer, LabelStmt> switchBlock = new LinkedHashMap<Integer, LabelStmt>();
        for (LBlock newBlock : linkedList) {
            switchBlock.put(newBlock.getKey().hashCode() ^ obfIndexI, newBlock.getLabelStmt());
        }
        LookupSwitchStmt lookupSwitchStmt = Stmts.nLookupSwitch((Value)obfIndex, (int[])switchBlock.keySet().stream().mapToInt(integer -> integer).toArray(), (LabelStmt[])switchBlock.values().toArray(new LabelStmt[0]), (LabelStmt)defaultTarget.getLabelStmt());
        newStmts.add((Stmt)lookupSwitchStmt);
        newStmts.add((Stmt)defaultTarget.getLabelStmt());
        newStmts.addAll(defaultTarget.getStmts());
        for (LBlock newBlock : linkedList) {
            newStmts.add((Stmt)newBlock.getLabelStmt());
            newStmts.addAll(newBlock.getStmts());
            if (newBlock.getNextKey().length() == 0) continue;
            Stmt stmt = newBlock.getStmts().get(newBlock.getStmts().size() - 1);
            if (stmt.st == Stmt.ST.GOTO || stmt.st == Stmt.ST.RETURN || stmt.st == Stmt.ST.THROW) continue;
            newStmts.addAll(newBlock.getStmts());
            newStmts.add((Stmt)Stmts.nAssign((Value)obfStr, (Value)Exprs.nString((String)newBlock.getNextKey())));
            newStmts.add((Stmt)Stmts.nGoto((LabelStmt)whileBlock.getLabelStmt()));
        }
        for (LBlock origBlock : origBlocks) {
            newStmts.add((Stmt)origBlock.getLabelStmt());
            if (!exceptionBlock.contains(origBlock.getLabelStmt())) {
                newStmts.addAll(origBlock.getStmts());
                continue;
            }
            newStmts.add((Stmt)Stmts.nAssign((Value)obfStr, (Value)obfStr));
        }
    }

    private boolean isCallSuper(Stmt stmt) {
        if (stmt.st == Stmt.ST.VOID_INVOKE) {
            Stmt.E1Stmt e1Stmt = (Stmt.E1Stmt)stmt;
            InvokeExpr expr = (InvokeExpr)e1Stmt.getOp();
            return "<init>".equals(expr.method.getName());
        }
        return false;
    }

    private InvokeExpr hashInvoke(Local strLocal) {
        return Exprs.nInvokeVirtual((Value[])new Value[]{strLocal}, (String)"Ljava/lang/String;", (String)"hashCode", (String[])new String[0], (String)"I");
    }

    private LBlock generateLBlock() {
        return new LBlock();
    }

    private List<LBlock> getAllBlock(List<Trap> traps, List<Stmt> origStmts) {
        ArrayList<LBlock> blocks = new ArrayList<LBlock>();
        LBlock lBlock = new LBlock();
        Trap trap = null;
        for (Stmt origStmt : origStmts) {
            if (origStmt.st == Stmt.ST.LABEL) {
                for (Trap t : traps) {
                    if (t.start == origStmt || t.end == origStmt) {
                        trap = t;
                        break;
                    }
                    trap = null;
                }
                blocks.add(lBlock);
                lBlock = new LBlock((LabelStmt)origStmt);
                if (trap == null) continue;
                lBlock.setTrap(trap);
                continue;
            }
            lBlock.getStmts().add(origStmt);
        }
        blocks.add(lBlock);
        return blocks;
    }

    private Value getNullValue(Value value) {
        Constant constant = null;
        switch (value.valueType) {
            case "I": {
                constant = Exprs.nInt((int)0);
                break;
            }
            case "S": {
                constant = Exprs.nShort((short)0);
                break;
            }
            case "J": {
                constant = Exprs.nLong((long)0L);
                break;
            }
            case "F": {
                constant = Exprs.nFloat((float)0.0f);
                break;
            }
            case "D": {
                constant = Exprs.nDouble((double)0.0);
                break;
            }
            case "C": {
                constant = Exprs.nChar((char)'\u0000');
                break;
            }
            case "B": {
                constant = Exprs.nByte((byte)0);
                break;
            }
            case "Z": {
                constant = new Constant((Object)false);
            }
        }
        if (constant == null) {
            constant = new Constant(Constant.Null);
        }
        constant.valueType = value.valueType;
        return constant;
    }
}

