/*
 * Decompiled with CFR 0.152.
 */
package top.niunaijun.obfuscator;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import top.niunaijun.obfuscator.ObfuscatorConfiguration;
import top.niunaijun.obfuscator.RebuildIfResult;
import top.niunaijun.obfuscator.chain.FlowObfuscator;
import top.niunaijun.obfuscator.chain.IfObfuscator;
import top.niunaijun.obfuscator.chain.SubObfuscator;
import top.niunaijun.obfuscator.chain.base.ObfuscatorChain;

public class IRObfuscator {
    private static IRObfuscator obfuscator;
    private final ObfuscatorConfiguration configuration;
    private final List<ObfuscatorChain> chains;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRObfuscator get(ObfuscatorConfiguration obf) {
        if (obfuscator != null) return obfuscator;
        Class<IRObfuscator> clazz = IRObfuscator.class;
        synchronized (IRObfuscator.class) {
            if (obfuscator != null) return obfuscator;
            obfuscator = new IRObfuscator(obf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return obfuscator;
        }
    }

    public IRObfuscator(ObfuscatorConfiguration configuration) {
        this.configuration = configuration;
        this.chains = new LinkedList<ObfuscatorChain>();
        this.chains.add(new FlowObfuscator(configuration));
        this.chains.add(new SubObfuscator(configuration));
        this.chains.add(new IfObfuscator(configuration));
    }

    public void reBuildInstructions(IrMethod ir) {
        if (this.configuration == null) {
            return;
        }
        if (!this.configuration.accept(ir.owner, ir.name)) {
            return;
        }
        block0: for (ObfuscatorChain chain : this.chains) {
            for (int i = 0; i < this.configuration.getObfDepth(); ++i) {
                ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
                ArrayList<Stmt> origStmts = new ArrayList<Stmt>();
                for (Stmt value : ir.stmts) {
                    origStmts.add(value);
                }
                for (Stmt stmt : ir.stmts) {
                    if (chain.canHandle(ir, stmt)) {
                        RebuildIfResult rebuildIfResult = chain.reBuild(ir, stmt, origStmts);
                        if (rebuildIfResult == null) continue;
                        newStmts.addAll(rebuildIfResult.getResult());
                        continue;
                    }
                    newStmts.add(stmt);
                }
                chain.reBuildEnd(ir, newStmts, origStmts);
                ir.stmts.clear();
                ir.stmts.addAll(newStmts);
                if (!chain.canDepth()) continue block0;
            }
        }
    }
}

