/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Representation of a file in a zip file")
@JsonPropertyOrder(value={"FileName", "FileContents"})
@JsonTypeName(value="ZipFile")
public class ZipFile {
    public static final String JSON_PROPERTY_FILE_NAME = "FileName";
    private String fileName;
    public static final String JSON_PROPERTY_FILE_CONTENTS = "FileContents";
    private byte[] fileContents;

    public ZipFile fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of this file")
    @JsonProperty(value="FileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ZipFile fileContents(byte[] fileContents) {
        this.fileContents = fileContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contents of this file")
    @JsonProperty(value="FileContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getFileContents() {
        return this.fileContents;
    }

    public void setFileContents(byte[] fileContents) {
        this.fileContents = fileContents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipFile zipFile = (ZipFile)o;
        return Objects.equals(this.fileName, zipFile.fileName) && Arrays.equals(this.fileContents, zipFile.fileContents);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, Arrays.hashCode(this.fileContents));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ZipFile {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    fileContents: ").append(this.toIndentedString(this.fileContents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

