/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.ZipDirectory;
import com.cloudmersive.client.rt.model.ZipFile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a zip extract operation")
@JsonPropertyOrder(value={"Successful", "FilesInZip", "DirectoriesInZip"})
@JsonTypeName(value="ZipExtractResponse")
public class ZipExtractResponse {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_FILES_IN_ZIP = "FilesInZip";
    private List<ZipFile> filesInZip = null;
    public static final String JSON_PROPERTY_DIRECTORIES_IN_ZIP = "DirectoriesInZip";
    private List<ZipDirectory> directoriesInZip = null;

    public ZipExtractResponse successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public ZipExtractResponse filesInZip(List<ZipFile> filesInZip) {
        this.filesInZip = filesInZip;
        return this;
    }

    public ZipExtractResponse addFilesInZipItem(ZipFile filesInZipItem) {
        if (this.filesInZip == null) {
            this.filesInZip = new ArrayList<ZipFile>();
        }
        this.filesInZip.add(filesInZipItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Top-level files in the root directory fo the zip file")
    @JsonProperty(value="FilesInZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ZipFile> getFilesInZip() {
        return this.filesInZip;
    }

    public void setFilesInZip(List<ZipFile> filesInZip) {
        this.filesInZip = filesInZip;
    }

    public ZipExtractResponse directoriesInZip(List<ZipDirectory> directoriesInZip) {
        this.directoriesInZip = directoriesInZip;
        return this;
    }

    public ZipExtractResponse addDirectoriesInZipItem(ZipDirectory directoriesInZipItem) {
        if (this.directoriesInZip == null) {
            this.directoriesInZip = new ArrayList<ZipDirectory>();
        }
        this.directoriesInZip.add(directoriesInZipItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Top-level directories in the root directory of the zip; directories can contain sub-directories and files")
    @JsonProperty(value="DirectoriesInZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ZipDirectory> getDirectoriesInZip() {
        return this.directoriesInZip;
    }

    public void setDirectoriesInZip(List<ZipDirectory> directoriesInZip) {
        this.directoriesInZip = directoriesInZip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipExtractResponse zipExtractResponse = (ZipExtractResponse)o;
        return Objects.equals(this.successful, zipExtractResponse.successful) && Objects.equals(this.filesInZip, zipExtractResponse.filesInZip) && Objects.equals(this.directoriesInZip, zipExtractResponse.directoriesInZip);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.filesInZip, this.directoriesInZip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ZipExtractResponse {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    filesInZip: ").append(this.toIndentedString(this.filesInZip)).append("\n");
        sb.append("    directoriesInZip: ").append(this.toIndentedString(this.directoriesInZip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

