/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to encrypt an existing Zip Archive file and protect it with a password")
@JsonPropertyOrder(value={"InputFileContents", "Password", "EncryptionAlgorithm"})
@JsonTypeName(value="ZipEncryptionAdvancedRequest")
public class ZipEncryptionAdvancedRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_CONTENTS = "InputFileContents";
    private byte[] inputFileContents;
    public static final String JSON_PROPERTY_PASSWORD = "Password";
    private String password;
    public static final String JSON_PROPERTY_ENCRYPTION_ALGORITHM = "EncryptionAlgorithm";
    private String encryptionAlgorithm;

    public ZipEncryptionAdvancedRequest inputFileContents(byte[] inputFileContents) {
        this.inputFileContents = inputFileContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Input Zip File archive contents in bytes")
    @JsonProperty(value="InputFileContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileContents() {
        return this.inputFileContents;
    }

    public void setInputFileContents(byte[] inputFileContents) {
        this.inputFileContents = inputFileContents;
    }

    public ZipEncryptionAdvancedRequest password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Password to place on the Zip file; the longer the password, the more secure")
    @JsonProperty(value="Password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ZipEncryptionAdvancedRequest encryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Encryption algorithm to use; possible values are AES-256 (recommended), AES-128, and PK-Zip (not recommended; legacy, weak encryption algorithm).  Default is AES-256.")
    @JsonProperty(value="EncryptionAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipEncryptionAdvancedRequest zipEncryptionAdvancedRequest = (ZipEncryptionAdvancedRequest)o;
        return Arrays.equals(this.inputFileContents, zipEncryptionAdvancedRequest.inputFileContents) && Objects.equals(this.password, zipEncryptionAdvancedRequest.password) && Objects.equals(this.encryptionAlgorithm, zipEncryptionAdvancedRequest.encryptionAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileContents), this.password, this.encryptionAlgorithm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ZipEncryptionAdvancedRequest {\n");
        sb.append("    inputFileContents: ").append(this.toIndentedString(this.inputFileContents)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    encryptionAlgorithm: ").append(this.toIndentedString(this.encryptionAlgorithm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

