/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing an XSS protection operation")
@JsonPropertyOrder(value={"Successful", "ContainedXss", "OriginalInput", "NormalizedResult"})
@JsonTypeName(value="XssProtectionResult")
public class XssProtectionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_CONTAINED_XSS = "ContainedXss";
    private Boolean containedXss;
    public static final String JSON_PROPERTY_ORIGINAL_INPUT = "OriginalInput";
    private String originalInput;
    public static final String JSON_PROPERTY_NORMALIZED_RESULT = "NormalizedResult";
    private String normalizedResult;

    public XssProtectionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public XssProtectionResult containedXss(Boolean containedXss) {
        this.containedXss = containedXss;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the input contained XSS scripting, false otherwise")
    @JsonProperty(value="ContainedXss")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getContainedXss() {
        return this.containedXss;
    }

    public void setContainedXss(Boolean containedXss) {
        this.containedXss = containedXss;
    }

    public XssProtectionResult originalInput(String originalInput) {
        this.originalInput = originalInput;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Original input string")
    @JsonProperty(value="OriginalInput")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalInput() {
        return this.originalInput;
    }

    public void setOriginalInput(String originalInput) {
        this.originalInput = originalInput;
    }

    public XssProtectionResult normalizedResult(String normalizedResult) {
        this.normalizedResult = normalizedResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Normalized string result, with XSS removed")
    @JsonProperty(value="NormalizedResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNormalizedResult() {
        return this.normalizedResult;
    }

    public void setNormalizedResult(String normalizedResult) {
        this.normalizedResult = normalizedResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XssProtectionResult xssProtectionResult = (XssProtectionResult)o;
        return Objects.equals(this.successful, xssProtectionResult.successful) && Objects.equals(this.containedXss, xssProtectionResult.containedXss) && Objects.equals(this.originalInput, xssProtectionResult.originalInput) && Objects.equals(this.normalizedResult, xssProtectionResult.normalizedResult);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.containedXss, this.originalInput, this.normalizedResult);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XssProtectionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    containedXss: ").append(this.toIndentedString(this.containedXss)).append("\n");
        sb.append("    originalInput: ").append(this.toIndentedString(this.originalInput)).append("\n");
        sb.append("    normalizedResult: ").append(this.toIndentedString(this.normalizedResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

