/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of performing a filter operation on XML input using XPath")
@JsonPropertyOrder(value={"Successful", "ResultingXmlDocument", "XmlNodesRemoved", "NodesRemovedCount"})
@JsonTypeName(value="XmlRemoveWithXPathResult")
public class XmlRemoveWithXPathResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_RESULTING_XML_DOCUMENT = "ResultingXmlDocument";
    private String resultingXmlDocument;
    public static final String JSON_PROPERTY_XML_NODES_REMOVED = "XmlNodesRemoved";
    private List<String> xmlNodesRemoved = null;
    public static final String JSON_PROPERTY_NODES_REMOVED_COUNT = "NodesRemovedCount";
    private Integer nodesRemovedCount;

    public XmlRemoveWithXPathResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public XmlRemoveWithXPathResult resultingXmlDocument(String resultingXmlDocument) {
        this.resultingXmlDocument = resultingXmlDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resulting, modified XML document with matching nodes removed as a string")
    @JsonProperty(value="ResultingXmlDocument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultingXmlDocument() {
        return this.resultingXmlDocument;
    }

    public void setResultingXmlDocument(String resultingXmlDocument) {
        this.resultingXmlDocument = resultingXmlDocument;
    }

    public XmlRemoveWithXPathResult xmlNodesRemoved(List<String> xmlNodesRemoved) {
        this.xmlNodesRemoved = xmlNodesRemoved;
        return this;
    }

    public XmlRemoveWithXPathResult addXmlNodesRemovedItem(String xmlNodesRemovedItem) {
        if (this.xmlNodesRemoved == null) {
            this.xmlNodesRemoved = new ArrayList<String>();
        }
        this.xmlNodesRemoved.add(xmlNodesRemovedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Matching selected XML nodes as strings")
    @JsonProperty(value="XmlNodesRemoved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getXmlNodesRemoved() {
        return this.xmlNodesRemoved;
    }

    public void setXmlNodesRemoved(List<String> xmlNodesRemoved) {
        this.xmlNodesRemoved = xmlNodesRemoved;
    }

    public XmlRemoveWithXPathResult nodesRemovedCount(Integer nodesRemovedCount) {
        this.nodesRemovedCount = nodesRemovedCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of the matching results")
    @JsonProperty(value="NodesRemovedCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNodesRemovedCount() {
        return this.nodesRemovedCount;
    }

    public void setNodesRemovedCount(Integer nodesRemovedCount) {
        this.nodesRemovedCount = nodesRemovedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlRemoveWithXPathResult xmlRemoveWithXPathResult = (XmlRemoveWithXPathResult)o;
        return Objects.equals(this.successful, xmlRemoveWithXPathResult.successful) && Objects.equals(this.resultingXmlDocument, xmlRemoveWithXPathResult.resultingXmlDocument) && Objects.equals(this.xmlNodesRemoved, xmlRemoveWithXPathResult.xmlNodesRemoved) && Objects.equals(this.nodesRemovedCount, xmlRemoveWithXPathResult.nodesRemovedCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.resultingXmlDocument, this.xmlNodesRemoved, this.nodesRemovedCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XmlRemoveWithXPathResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    resultingXmlDocument: ").append(this.toIndentedString(this.resultingXmlDocument)).append("\n");
        sb.append("    xmlNodesRemoved: ").append(this.toIndentedString(this.xmlNodesRemoved)).append("\n");
        sb.append("    nodesRemovedCount: ").append(this.toIndentedString(this.nodesRemovedCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

