/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Cell in an Excel Spreadsheet worksheet")
@JsonPropertyOrder(value={"Path", "TextValue", "CellIdentifier", "StyleIndex", "Formula"})
@JsonTypeName(value="XlsxSpreadsheetCell")
public class XlsxSpreadsheetCell {
    public static final String JSON_PROPERTY_PATH = "Path";
    private String path;
    public static final String JSON_PROPERTY_TEXT_VALUE = "TextValue";
    private String textValue;
    public static final String JSON_PROPERTY_CELL_IDENTIFIER = "CellIdentifier";
    private String cellIdentifier;
    public static final String JSON_PROPERTY_STYLE_INDEX = "StyleIndex";
    private Integer styleIndex;
    public static final String JSON_PROPERTY_FORMULA = "Formula";
    private String formula;

    public XlsxSpreadsheetCell path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Path of the location of this object; leave blank for new rows")
    @JsonProperty(value="Path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public XlsxSpreadsheetCell textValue(String textValue) {
        this.textValue = textValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text value of the cell")
    @JsonProperty(value="TextValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public XlsxSpreadsheetCell cellIdentifier(String cellIdentifier) {
        this.cellIdentifier = cellIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cell reference of the cell, e.g. A1, Z22, etc.")
    @JsonProperty(value="CellIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCellIdentifier() {
        return this.cellIdentifier;
    }

    public void setCellIdentifier(String cellIdentifier) {
        this.cellIdentifier = cellIdentifier;
    }

    public XlsxSpreadsheetCell styleIndex(Integer styleIndex) {
        this.styleIndex = styleIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier for the style to apply to this style")
    @JsonProperty(value="StyleIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStyleIndex() {
        return this.styleIndex;
    }

    public void setStyleIndex(Integer styleIndex) {
        this.styleIndex = styleIndex;
    }

    public XlsxSpreadsheetCell formula(String formula) {
        this.formula = formula;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="Formula")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XlsxSpreadsheetCell xlsxSpreadsheetCell = (XlsxSpreadsheetCell)o;
        return Objects.equals(this.path, xlsxSpreadsheetCell.path) && Objects.equals(this.textValue, xlsxSpreadsheetCell.textValue) && Objects.equals(this.cellIdentifier, xlsxSpreadsheetCell.cellIdentifier) && Objects.equals(this.styleIndex, xlsxSpreadsheetCell.styleIndex) && Objects.equals(this.formula, xlsxSpreadsheetCell.formula);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.textValue, this.cellIdentifier, this.styleIndex, this.formula);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XlsxSpreadsheetCell {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    textValue: ").append(this.toIndentedString(this.textValue)).append("\n");
        sb.append("    cellIdentifier: ").append(this.toIndentedString(this.cellIdentifier)).append("\n");
        sb.append("    styleIndex: ").append(this.toIndentedString(this.styleIndex)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString(this.formula)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

